/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class PrintWriter
extends Writer {
    private boolean autoflush;
    private boolean error;
    protected Writer out;
    private static final char[] line_separator = System.getProperty("line.separator").toCharArray();

    public PrintWriter(Writer writer) {
        super(writer);
        this.out = writer;
    }

    public PrintWriter(Writer writer, boolean bl) {
        super(writer);
        this.out = writer;
        this.autoflush = bl;
    }

    public PrintWriter(OutputStream outputStream) {
        this.out = new OutputStreamWriter(outputStream);
        this.lock = this.out;
    }

    public PrintWriter(OutputStream outputStream, boolean bl) {
        this(outputStream);
        this.autoflush = bl;
    }

    protected void setError() {
        this.error = true;
    }

    public boolean checkError() {
        this.flush();
        return this.error;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void print(String string) {
        this.write(string == null ? "null" : string);
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(int n) {
        this.write(Integer.toString(n));
    }

    public void print(long l) {
        this.write(Long.toString(l));
    }

    public void print(float f) {
        this.write(Float.toString(f));
    }

    public void print(double d) {
        this.write(Double.toString(d));
    }

    public void print(Object object) {
        this.write(object == null ? "null" : object.toString());
    }

    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                try {
                    this.write(line_separator, 0, line_separator.length);
                    if (this.autoflush) {
                        this.out.flush();
                    }
                }
                catch (IOException iOException) {
                    this.error = true;
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public void println(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(bl);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void println(int n) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(n);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(l);
                this.println();
            }
            finally {
                Object var5_3 = null;
            }
            return;
        }
    }

    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(f);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(d);
                this.println();
            }
            finally {
                Object var5_3 = null;
            }
            return;
        }
    }

    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            try {
                this.print(object);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(string);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(c);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.print(cArray);
                this.println();
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public void write(int n) {
        try {
            this.out.write(n);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        try {
            this.out.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(String string, int n, int n2) {
        try {
            this.out.write(string, n, n2);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }
}

