/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    PipedWriter source;
    boolean closed;
    static final int PIPE_SIZE = 2048;
    char[] buffer;
    int in;
    int out;
    char[] read_buf;

    private /* synthetic */ void finit$() {
        this.buffer = new char[2048];
        this.in = -1;
        this.out = 0;
        this.read_buf = new char[1];
    }

    public PipedReader() {
        this.finit$();
    }

    public PipedReader(PipedWriter pipedWriter) throws IOException {
        this.finit$();
        this.connect(pipedWriter);
    }

    public void connect(PipedWriter pipedWriter) throws IOException {
        if (this.source != null || pipedWriter.sink != null) {
            throw new IOException("Already connected");
        }
        pipedWriter.sink = this;
        this.source = pipedWriter;
    }

    void receive(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                int n3 = n;
                while (n2 > 0) {
                    try {
                        while (this.in == this.out) {
                            this.lock.notifyAll();
                            this.lock.wait();
                            if (!this.closed) continue;
                            throw new IOException("Pipe closed");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                    if (this.in < 0) {
                        this.in = 0;
                    }
                    int n4 = this.in < this.out ? Math.min(n2, this.out - this.in) : Math.min(n2, this.buffer.length - this.in);
                    System.arraycopy(cArray, n3, this.buffer, this.in, n4);
                    n2 -= n4;
                    n3 += n4;
                    this.in += n4;
                    if (this.in != this.buffer.length) continue;
                    this.in = 0;
                }
                this.lock.notifyAll();
            }
            finally {
                Object var6_8 = null;
            }
            return;
        }
    }

    public int read() throws IOException {
        int n = this.read(this.read_buf, 0, 1);
        if (n == -1) {
            return -1;
        }
        return this.read_buf[0];
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            try {
                if (this.source == null) {
                    throw new IOException("Not connected");
                }
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                try {
                    while (this.in < 0) {
                        if (this.source.closed) {
                            int n4 = -1;
                            Object var7_7 = null;
                            return n4;
                        }
                        this.lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                int n5 = 0;
                do {
                    int n6 = this.out < this.in ? Math.min(n2, this.in - this.out) : Math.min(n2, this.buffer.length - this.out);
                    System.arraycopy(this.buffer, this.out, cArray, n, n6);
                    n += n6;
                    n2 -= n6;
                    this.out += n6;
                    n5 += n6;
                    if (this.out == this.buffer.length) {
                        this.out = 0;
                    }
                    if (this.out != this.in) continue;
                    this.in = -1;
                    this.out = 0;
                } while (n2 != 0 && this.in != -1);
                this.lock.notifyAll();
                n3 = n5;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                throw throwable;
            }
            Object var7_9 = null;
            return n3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.closed) {
                    throw new IOException("Pipe closed");
                }
                if (this.in < 0) {
                    boolean bl2 = false;
                    Object var4_4 = null;
                    return bl2;
                }
                int n = this.out < this.in ? this.in - this.out : this.buffer.length - this.out - this.in;
                bl = n > 0;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
            Object var4_5 = null;
            return bl;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.closed = true;
                this.lock.notifyAll();
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }
}

