/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.UnicodeToBytes;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    BufferedOutputStream out;
    UnicodeToBytes converter;
    private char[] work;
    private int wcount;

    public String getEncoding() {
        return this.converter.getName();
    }

    private OutputStreamWriter(OutputStream outputStream, UnicodeToBytes unicodeToBytes) {
        this.out = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 250);
        this.lock = outputStream;
        this.converter = unicodeToBytes;
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, UnicodeToBytes.getEncoder(string));
    }

    public OutputStreamWriter(OutputStream outputStream) {
        this(outputStream, UnicodeToBytes.getDefaultEncoder());
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out != null) {
                    this.flush();
                    this.out.close();
                    this.out = null;
                }
                this.work = null;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wcount > 0) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.out.flush();
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wcount > 0) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.writeChars(cArray, n, n2);
            }
            finally {
                Object var6_5 = null;
            }
            return;
        }
    }

    private void writeChars(char[] cArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            if (this.out.count + n2 >= this.out.buf.length) {
                this.out.flush();
                if (this.out.count != 0) {
                    throw new IOException("unable to flush output byte buffer");
                }
            }
            this.converter.setOutput(this.out.buf, this.out.count);
            int n3 = this.converter.write(cArray, n, n2);
            n += n3;
            n2 -= n3;
            this.out.count = this.converter.count;
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                int n3 = this.work.length;
                while (n2 > 0) {
                    int n4 = n2;
                    if (this.wcount + n4 > n3) {
                        if (2 * this.wcount > n3) {
                            this.writeChars(this.work, 0, this.wcount);
                            this.wcount = 0;
                        }
                        if (this.wcount + n4 > n3) {
                            n4 = n3 - this.wcount;
                        }
                    }
                    string.getChars(n, n + n4, this.work, this.wcount);
                    n += n4;
                    n2 -= n4;
                    this.wcount += n4;
                }
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                throw throwable;
            }
        }
    }

    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                if (this.wcount >= this.work.length) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.work[this.wcount++] = (char)n;
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }
}

