/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.NullOutputStream;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.provider.Gnu;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterfaceComparator;
import java.io.InvalidClassException;
import java.io.MemberComparator;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static Hashtable classLookupTable = new Hashtable();
    private static final NullOutputStream nullOutputStream = new NullOutputStream();
    private static final Comparator interfaceComparator = new InterfaceComparator();
    private static final Comparator memberComparator = new MemberComparator();
    private static final Class[] writeMethodArgTypes = new Class[]{ObjectStreamClass.class$("java.io.ObjectOutputStream")};
    private ObjectStreamClass superClass;
    private Class clazz;
    private String name;
    private long uid;
    private byte flags;
    ObjectStreamField[] fields;
    int primFieldSize;
    int objectFieldCount;
    private static final long serialVersionUID = -6120832682080437368L;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.primFieldSize = -1;
    }

    public static ObjectStreamClass lookup(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (!ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(clazz)) {
            return null;
        }
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)classLookupTable.get(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass;
        }
        objectStreamClass = new ObjectStreamClass(clazz);
        classLookupTable.put(clazz, objectStreamClass);
        return objectStreamClass;
    }

    public String getName() {
        return this.name;
    }

    public Class forClass() {
        return this.clazz;
    }

    public long getSerialVersionUID() {
        return this.uid;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.fields.length];
        System.arraycopy(this.fields, 0, objectStreamFieldArray, 0, this.fields.length);
        return objectStreamFieldArray;
    }

    public ObjectStreamField getField(String string) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getName().equals(string)) continue;
            return this.fields[i];
        }
        return null;
    }

    public String toString() {
        return "java.io.ObjectStreamClass< " + this.name + ", " + this.uid + " >";
    }

    boolean hasWriteMethod() {
        return (this.flags & 1) != 0;
    }

    boolean isSerializable() {
        return (this.flags & 2) != 0;
    }

    boolean isExternalizable() {
        return (this.flags & 4) != 0;
    }

    ObjectStreamClass getSuper() {
        return this.superClass;
    }

    static ObjectStreamClass[] getObjectStreamClasses(Class clazz) {
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass == null) {
            return new ObjectStreamClass[0];
        }
        Vector vector = new Vector();
        while (objectStreamClass != null) {
            vector.addElement(objectStreamClass);
            objectStreamClass = objectStreamClass.getSuper();
        }
        int n = vector.size();
        ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n];
        for (int i = n - 1; i >= 0; --i) {
            objectStreamClassArray[n - i - 1] = (ObjectStreamClass)vector.elementAt(i);
        }
        return objectStreamClassArray;
    }

    int getFlags() {
        return this.flags;
    }

    ObjectStreamClass(String string, long l, byte by, ObjectStreamField[] objectStreamFieldArray) {
        this.finit$();
        this.name = string;
        this.uid = l;
        this.flags = by;
        this.fields = objectStreamFieldArray;
    }

    void setClass(Class clazz) throws InvalidClassException {
        this.clazz = clazz;
        long l = this.getClassUID(clazz);
        if (this.uid == 0L) {
            this.uid = l;
            return;
        }
        if (this.uid != l) {
            String string = clazz + ": Local class not compatible: stream serialVersionUID=" + this.uid + ", local serialVersionUID=" + l;
            throw new InvalidClassException(string);
        }
    }

    void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superClass = objectStreamClass;
    }

    void calculateOffsets() {
        ObjectStreamField objectStreamField;
        int n;
        this.primFieldSize = 0;
        int n2 = this.fields.length;
        block6: for (n = 0; n < n2 && (objectStreamField = this.fields[n]).isPrimitive(); ++n) {
            objectStreamField.setOffset(this.primFieldSize);
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    ++this.primFieldSize;
                    continue block6;
                }
                case 'C': 
                case 'S': {
                    this.primFieldSize += 2;
                    continue block6;
                }
                case 'F': 
                case 'I': {
                    this.primFieldSize += 4;
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    this.primFieldSize += 8;
                }
            }
        }
        this.objectFieldCount = 0;
        while (n < n2) {
            this.fields[n].setOffset(this.objectFieldCount++);
            ++n;
        }
    }

    private ObjectStreamClass(Class clazz) {
        this.finit$();
        this.uid = 0L;
        this.flags = 0;
        this.clazz = clazz;
        this.name = clazz.getName();
        this.setFlags(clazz);
        this.setFields(clazz);
        this.uid = this.getClassUID(clazz);
        this.superClass = ObjectStreamClass.lookup(clazz.getSuperclass());
    }

    private void setFlags(Class clazz) {
        if (ObjectStreamClass.class$("java.io.Externalizable").isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 4);
        } else if (ObjectStreamClass.class$("java.io.Serializable").isAssignableFrom(clazz)) {
            this.flags = (byte)(this.flags | 2);
        }
        try {
            Method method = clazz.getDeclaredMethod("writeObject", writeMethodArgTypes);
            int n = method.getModifiers();
            if (method.getReturnType() == Void.TYPE && Modifier.isPrivate(n) && !Modifier.isStatic(n)) {
                this.flags = (byte)(this.flags | 1);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void setFields(Class clazz) {
        int n;
        if (!this.isSerializable() || this.isExternalizable()) {
            this.fields = NO_FIELDS;
            return;
        }
        try {
            Field field = clazz.getDeclaredField("serialPersistentFields");
            int n2 = field.getModifiers();
            if (Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2)) {
                this.fields = this.getSerialPersistentFields(clazz);
                Arrays.sort(this.fields);
                this.calculateOffsets();
                return;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        int n3 = 0;
        Field[] fieldArray = clazz.getDeclaredFields();
        for (n = 0; n < fieldArray.length; ++n) {
            int n4 = fieldArray[n].getModifiers();
            if (Modifier.isTransient(n4) || Modifier.isStatic(n4)) {
                fieldArray[n] = null;
                continue;
            }
            ++n3;
        }
        this.fields = new ObjectStreamField[n3];
        n = 0;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (fieldArray[i] == null) continue;
            Field field = fieldArray[i];
            this.fields[n] = new ObjectStreamField(field.getName(), field.getType());
            ++n;
        }
        Arrays.sort(this.fields);
        this.calculateOffsets();
    }

    private long getClassUID(Class clazz) {
        Object object;
        try {
            object = clazz.getDeclaredField("serialVersionUID");
            int n = ((Field)object).getModifiers();
            if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                return ((Field)object).getLong(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            int n;
            Object[] objectArray;
            object = null;
            DigestOutputStream digestOutputStream = null;
            DataOutputStream dataOutputStream = null;
            try {
                object = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                objectArray = new Gnu();
                Security.addProvider((Provider)objectArray);
                object = MessageDigest.getInstance("SHA");
            }
            digestOutputStream = new DigestOutputStream(nullOutputStream, (MessageDigest)object);
            dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = clazz.getModifiers();
            dataOutputStream.writeInt(n2 &= 0x611);
            if (!clazz.isArray()) {
                objectArray = clazz.getInterfaces();
                Arrays.sort(objectArray, interfaceComparator);
                for (int i = 0; i < objectArray.length; ++i) {
                    dataOutputStream.writeUTF(((Class)objectArray[i]).getName());
                }
            }
            objectArray = clazz.getDeclaredFields();
            Arrays.sort(objectArray, memberComparator);
            for (n = 0; n < objectArray.length; ++n) {
                Object object2 = objectArray[n];
                n2 = ((Field)object2).getModifiers();
                if (Modifier.isPrivate(n2) && (Modifier.isStatic(n2) || Modifier.isTransient(n2))) continue;
                dataOutputStream.writeUTF(((Field)object2).getName());
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(TypeSignature.getEncodingOfClass(((Field)object2).getType()));
            }
            try {
                n = ObjectStreamClass.hasClassInitializer(clazz) ? 1 : 0;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                n = 0;
            }
            if (n != 0) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            Object[] objectArray2 = clazz.getDeclaredConstructors();
            Arrays.sort(objectArray2, memberComparator);
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object3 = objectArray2[i];
                n2 = ((Constructor)object3).getModifiers();
                if (Modifier.isPrivate(n2)) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(TypeSignature.getEncodingOfConstructor((Constructor)object3).replace('/', '.'));
            }
            Object[] objectArray3 = clazz.getDeclaredMethods();
            Arrays.sort(objectArray3, memberComparator);
            for (int i = 0; i < objectArray3.length; ++i) {
                Object object4 = objectArray3[i];
                n2 = ((Method)object4).getModifiers();
                if (Modifier.isPrivate(n2)) continue;
                dataOutputStream.writeUTF(((Method)object4).getName());
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(TypeSignature.getEncodingOfMethod((Method)object4).replace('/', '.'));
            }
            dataOutputStream.close();
            byte[] byArray = ((MessageDigest)object).digest();
            long l = 0L;
            int n3 = byArray.length < 8 ? byArray.length : 8;
            for (int i = 0; i < n3; ++i) {
                l += (long)(byArray[i] & 0xFF) << (8 * i & 0x3F);
            }
            return l;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("The SHA algorithm was not found to use in computing the Serial Version UID for class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    private ObjectStreamField[] getSerialPersistentFields(Class clazz) {
        ObjectStreamField[] objectStreamFieldArray = null;
        try {
            Field field = clazz.getDeclaredField("getSerialPersistentFields");
            objectStreamFieldArray = (ObjectStreamField[])field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return objectStreamFieldArray;
    }

    private static boolean hasClassInitializer(Class clazz) {
        Method method = null;
        try {
            Class[] classArray = new Class[]{};
            method = clazz.getDeclaredMethod("<clinit>", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError();
        }
        return method != null;
    }
}

