/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import gnu.java.lang.reflect.TypeSignature;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static int defaultProtocolVersion = 1;
    private DataOutputStream dataOutput;
    private boolean writeDataAsBlocks;
    private DataOutputStream realOutput;
    private DataOutputStream blockDataOutput;
    private byte[] blockData;
    private int blockDataCount;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private PutField currentPutField;
    private boolean fieldsAlreadyWritten;
    private boolean replacementEnabled;
    private boolean isSerializing;
    private int nextOID;
    private Hashtable OIDLookupTable;
    private int protocolVersion;
    private boolean useSubclassMethod;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ObjectStreamClass access$1(ObjectOutputStream objectOutputStream, ObjectStreamClass objectStreamClass) {
        objectOutputStream.currentObjectStreamClass = objectStreamClass;
        return objectOutputStream.currentObjectStreamClass;
    }

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.realOutput = new DataOutputStream(outputStream);
        this.blockData = new byte[1024];
        this.blockDataCount = 0;
        this.blockDataOutput = new DataOutputStream(this);
        this.setBlockDataMode(true);
        this.replacementEnabled = false;
        this.isSerializing = false;
        this.nextOID = 0x7E0000;
        this.OIDLookupTable = new Hashtable();
        this.protocolVersion = defaultProtocolVersion;
        this.useSubclassMethod = false;
        this.writeStreamHeader();
    }

    public final void writeObject(Object object) throws IOException {
        if (this.useSubclassMethod) {
            this.writeObjectOverride(object);
            return;
        }
        boolean bl = this.isSerializing;
        if (!bl) {
            this.setBlockDataMode(false);
        }
        try {
            block35: {
                try {
                    Object object2;
                    Object[] objectArray;
                    Object object3;
                    this.isSerializing = true;
                    boolean bl2 = false;
                    this.drain();
                    while (true) {
                        if (object == null) {
                            this.realOutput.writeByte(112);
                            break block35;
                        }
                        Integer n = this.findHandle(object);
                        if (n != null) {
                            this.realOutput.writeByte(113);
                            this.realOutput.writeInt(n);
                            break block35;
                        }
                        if (object instanceof Class) {
                            this.realOutput.writeByte(118);
                            this.writeObject(ObjectStreamClass.lookup((Class)object));
                            this.assignNewHandle(object);
                            break block35;
                        }
                        if (object instanceof ObjectStreamClass) {
                            object3 = (ObjectStreamClass)object;
                            this.realOutput.writeByte(114);
                            this.realOutput.writeUTF(((ObjectStreamClass)object3).getName());
                            this.realOutput.writeLong(((ObjectStreamClass)object3).getSerialVersionUID());
                            this.assignNewHandle(object);
                            int n2 = ((ObjectStreamClass)object3).getFlags();
                            if (this.protocolVersion == 2 && ((ObjectStreamClass)object3).isExternalizable()) {
                                n2 |= 8;
                            }
                            this.realOutput.writeByte(n2);
                            objectArray = ((ObjectStreamClass)object3).fields;
                            this.realOutput.writeShort(objectArray.length);
                            for (int i = 0; i < objectArray.length; ++i) {
                                Object object4 = objectArray[i];
                                this.realOutput.writeByte(((ObjectStreamField)object4).getTypeCode());
                                this.realOutput.writeUTF(((ObjectStreamField)object4).getName());
                                if (((ObjectStreamField)object4).isPrimitive()) continue;
                                this.writeObject(((ObjectStreamField)object4).getTypeString());
                            }
                            this.setBlockDataMode(true);
                            this.annotateClass(((ObjectStreamClass)object3).forClass());
                            this.setBlockDataMode(false);
                            this.realOutput.writeByte(120);
                            if (((ObjectStreamClass)object3).isSerializable()) {
                                this.writeObject(((ObjectStreamClass)object3).getSuper());
                            } else {
                                this.writeObject(null);
                            }
                            break block35;
                        }
                        object3 = null;
                        if (!this.replacementEnabled && !(object instanceof Serializable) || bl2) break;
                        object3 = object;
                        if (object instanceof Serializable) {
                            object2 = null;
                            try {
                                objectArray = new Class[]{};
                                object2 = object.getClass().getDeclaredMethod("writeReplace", (Class[])objectArray);
                                object = ((Method)object2).invoke(object, new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                // empty catch block
                            }
                        }
                        if (this.replacementEnabled) {
                            object = this.replaceObject(object);
                        }
                        bl2 = true;
                    }
                    if (object instanceof String) {
                        this.realOutput.writeByte(116);
                        this.assignNewHandle(object);
                        this.realOutput.writeUTF((String)object);
                        break block35;
                    }
                    object2 = object.getClass();
                    objectArray = ObjectStreamClass.lookup((Class)object2);
                    if (objectArray == null) {
                        throw new NotSerializableException(((Class)object2).getName());
                    }
                    if (((Class)object2).isArray()) {
                        this.realOutput.writeByte(117);
                        this.writeObject(objectArray);
                        this.assignNewHandle(object);
                        this.writeArraySizeAndElements(object, ((Class)object2).getComponentType());
                        break block35;
                    }
                    this.realOutput.writeByte(115);
                    this.writeObject(objectArray);
                    if (bl2) {
                        this.assignNewHandle(object3);
                    } else {
                        this.assignNewHandle(object);
                    }
                    if (object instanceof Externalizable) {
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(true);
                        }
                        ((Externalizable)object).writeExternal(this);
                        if (this.protocolVersion == 2) {
                            this.setBlockDataMode(false);
                            this.drain();
                        }
                        break block35;
                    }
                    if (object instanceof Serializable) {
                        this.currentObject = object;
                        ObjectStreamClass[] objectStreamClassArray = ObjectStreamClass.getObjectStreamClasses((Class)object2);
                        for (int i = 0; i < objectStreamClassArray.length; ++i) {
                            this.currentObjectStreamClass = objectStreamClassArray[i];
                            this.fieldsAlreadyWritten = false;
                            boolean bl3 = this.currentObjectStreamClass.hasWriteMethod();
                            this.writeFields(object, this.currentObjectStreamClass.fields, bl3);
                            if (!bl3) continue;
                            this.drain();
                            this.realOutput.writeByte(120);
                        }
                        this.currentObject = null;
                        this.currentObjectStreamClass = null;
                        this.currentPutField = null;
                        break block35;
                    }
                    throw new NotSerializableException(((Class)object2).getName());
                }
                catch (IOException iOException) {
                    this.realOutput.writeByte(123);
                    this.reset(true);
                    try {
                        this.writeObject(iOException);
                    }
                    catch (IOException iOException2) {
                        throw new StreamCorruptedException("Exception " + iOException2 + " thrown while exception was being written to stream.");
                    }
                    this.reset(true);
                }
            }
            Object var3_5 = null;
            this.isSerializing = bl;
            if (!bl) {
                this.setBlockDataMode(true);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.isSerializing = bl;
            if (!bl) {
                this.setBlockDataMode(true);
            }
            throw throwable;
        }
    }

    public void defaultWriteObject() throws NotActiveException, IOException {
        this.markFieldsWritten();
        this.writeFields(this.currentObject, this.currentObjectStreamClass.fields, false);
    }

    private void markFieldsWritten() throws IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultWriteObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyWritten) {
            throw new IOException("Only one of putFields and defaultWriteObject may be called, and it may only be called once");
        }
        this.fieldsAlreadyWritten = true;
    }

    public void reset() throws IOException {
        this.reset(false);
    }

    private void reset(boolean bl) throws IOException {
        if (!bl) {
            if (this.isSerializing) {
                throw new IOException("Reset called while serialization in progress");
            }
            this.realOutput.writeByte(121);
        }
        this.clearHandles();
    }

    public void useProtocolVersion(int n) throws IOException {
        if (n != 1 && n != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        this.protocolVersion = n;
    }

    public static void setDefaultProtocolVersion(int n) throws IOException {
        if (n != 1 && n != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        defaultProtocolVersion = n;
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) {
        if (bl && this.getClass().getClassLoader() != null) {
            throw new SecurityException("Untrusted ObjectOutputStream subclass attempted to enable object replacement");
        }
        boolean bl2 = this.replacementEnabled;
        this.replacementEnabled = bl;
        return bl2;
    }

    protected void writeStreamHeader() throws IOException {
        this.realOutput.writeShort(-21267);
        this.realOutput.writeShort(5);
    }

    protected ObjectOutputStream() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected void writeObjectOverride(Object object) throws IOException, NotActiveException {
        throw new NotActiveException("Subclass of ObjectOutputStream must implement writeObjectOverride");
    }

    public void write(int n) throws IOException {
        if (this.writeDataAsBlocks) {
            if (this.blockDataCount == 1024) {
                this.drain();
            }
            this.blockData[this.blockDataCount++] = (byte)n;
        } else {
            this.realOutput.write(n);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.writeDataAsBlocks) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.blockDataCount + n2 < 1024) {
                System.arraycopy(byArray, n, this.blockData, this.blockDataCount, n2);
                this.blockDataCount += n2;
            } else {
                this.drain();
                this.writeBlockDataHeader(n2);
                this.realOutput.write(byArray, n, n2);
            }
        } else {
            this.realOutput.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        this.drain();
        this.realOutput.flush();
    }

    protected void drain() throws IOException {
        if (this.blockDataCount == 0) {
            return;
        }
        this.writeBlockDataHeader(this.blockDataCount);
        this.realOutput.write(this.blockData, 0, this.blockDataCount);
        this.blockDataCount = 0;
    }

    public void close() throws IOException {
        this.drain();
        this.realOutput.close();
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.dataOutput.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.dataOutput.writeByte(n);
    }

    public void writeShort(int n) throws IOException {
        this.dataOutput.writeShort(n);
    }

    public void writeChar(int n) throws IOException {
        this.dataOutput.writeChar(n);
    }

    public void writeInt(int n) throws IOException {
        this.dataOutput.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.dataOutput.writeLong(l);
    }

    public void writeFloat(float f) throws IOException {
        this.dataOutput.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.dataOutput.writeDouble(d);
    }

    public void writeBytes(String string) throws IOException {
        this.dataOutput.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.dataOutput.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.dataOutput.writeUTF(string);
    }

    public PutField putFields() throws IOException {
        this.markFieldsWritten();
        this.currentPutField = new PutField(this){
            private /* synthetic */ ObjectOutputStream this$0;
            private byte[] prim_field_data;
            private Object[] objs;
            {
                this.this$0 = objectOutputStream;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.prim_field_data = new byte[((ObjectOutputStream)this.this$0).currentObjectStreamClass.primFieldSize];
                this.objs = new Object[((ObjectOutputStream)this.this$0).currentObjectStreamClass.objectFieldCount];
            }

            public void put(String string, boolean bl) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'Z');
                this.prim_field_data[objectStreamField.getOffset()] = bl ? (byte)1 : 0;
            }

            public void put(String string, byte by) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'B');
                this.prim_field_data[objectStreamField.getOffset()] = by;
            }

            public void put(String string, char c) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'C');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(c >>> 8);
                this.prim_field_data[n] = (byte)c;
            }

            public void put(String string, double d) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'D');
                int n = objectStreamField.getOffset();
                long l = Double.doubleToLongBits(d);
                this.prim_field_data[n++] = (byte)(l >>> 52);
                this.prim_field_data[n++] = (byte)(l >>> 48);
                this.prim_field_data[n++] = (byte)(l >>> 40);
                this.prim_field_data[n++] = (byte)(l >>> 32);
                this.prim_field_data[n++] = (byte)(l >>> 24);
                this.prim_field_data[n++] = (byte)(l >>> 16);
                this.prim_field_data[n++] = (byte)(l >>> 8);
                this.prim_field_data[n] = (byte)l;
            }

            public void put(String string, float f) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'F');
                int n = objectStreamField.getOffset();
                int n2 = Float.floatToIntBits(f);
                this.prim_field_data[n++] = (byte)(n2 >>> 24);
                this.prim_field_data[n++] = (byte)(n2 >>> 16);
                this.prim_field_data[n++] = (byte)(n2 >>> 8);
                this.prim_field_data[n] = (byte)n2;
            }

            public void put(String string, int n) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'I');
                int n2 = objectStreamField.getOffset();
                this.prim_field_data[n2++] = (byte)(n >>> 24);
                this.prim_field_data[n2++] = (byte)(n >>> 16);
                this.prim_field_data[n2++] = (byte)(n >>> 8);
                this.prim_field_data[n2] = (byte)n;
            }

            public void put(String string, long l) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'J');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(l >>> 52);
                this.prim_field_data[n++] = (byte)(l >>> 48);
                this.prim_field_data[n++] = (byte)(l >>> 40);
                this.prim_field_data[n++] = (byte)(l >>> 32);
                this.prim_field_data[n++] = (byte)(l >>> 24);
                this.prim_field_data[n++] = (byte)(l >>> 16);
                this.prim_field_data[n++] = (byte)(l >>> 8);
                this.prim_field_data[n] = (byte)l;
            }

            public void put(String string, short s) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                this.checkType(objectStreamField, 'S');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(s >>> 8);
                this.prim_field_data[n] = (byte)s;
            }

            public void put(String string, Object object) throws IOException {
                ObjectStreamField objectStreamField = this.this$0.currentObjectStreamClass.getField(string);
                if (object != null && !objectStreamField.getType().isAssignableFrom(object.getClass())) {
                    throw new IllegalArgumentException();
                }
                this.objs[objectStreamField.getOffset()] = object;
            }

            public void write(ObjectOutput objectOutput) throws IOException {
                this.this$0.setBlockDataMode(false);
                objectOutput.write(this.prim_field_data);
                for (int i = 0; i < this.objs.length; ++i) {
                    objectOutput.writeObject(this.objs[i]);
                }
                this.this$0.setBlockDataMode(true);
            }

            private void checkType(ObjectStreamField objectStreamField, char c) {
                if (TypeSignature.getEncodingOfClass(objectStreamField.getType()).charAt(0) != c) {
                    throw new IllegalArgumentException();
                }
            }
        };
        return this.currentPutField;
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException("writeFields can only be called after putFields has been called");
        }
        this.currentPutField.write(this);
    }

    private void writeBlockDataHeader(int n) throws IOException {
        if (n < 256) {
            this.realOutput.writeByte(119);
            this.realOutput.write(n);
        } else {
            this.realOutput.writeByte(122);
            this.realOutput.writeInt(n);
        }
    }

    private Integer findHandle(Object object) {
        return (Integer)this.OIDLookupTable.get(new ObjectIdentityWrapper(object));
    }

    private int assignNewHandle(Object object) {
        this.OIDLookupTable.put(new ObjectIdentityWrapper(object), new Integer(this.nextOID));
        return this.nextOID++;
    }

    private void clearHandles() {
        this.nextOID = 0x7E0000;
        this.OIDLookupTable.clear();
    }

    private void writeArraySizeAndElements(Object object, Class clazz) throws IOException {
        int n = Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeBoolean(blArray[i]);
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeByte(byArray[i]);
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeChar(cArray[i]);
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeDouble(dArray[i]);
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeFloat(fArray[i]);
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeInt(nArray[i]);
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeLong(lArray[i]);
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.realOutput.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    this.realOutput.writeShort(sArray[i]);
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            this.realOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeObject(objectArray[i]);
            }
        }
    }

    private void writeFields(Object object, ObjectStreamField[] objectStreamFieldArray, boolean bl) throws IOException {
        if (bl) {
            this.setBlockDataMode(true);
            this.callWriteMethod(object);
            this.setBlockDataMode(false);
            return;
        }
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            String string = objectStreamFieldArray[i].getName();
            Class clazz = objectStreamFieldArray[i].getType();
            if (clazz == Boolean.TYPE) {
                this.realOutput.writeBoolean(this.getBooleanField(object, string));
                continue;
            }
            if (clazz == Byte.TYPE) {
                this.realOutput.writeByte(this.getByteField(object, string));
                continue;
            }
            if (clazz == Character.TYPE) {
                this.realOutput.writeChar(this.getCharField(object, string));
                continue;
            }
            if (clazz == Double.TYPE) {
                this.realOutput.writeDouble(this.getDoubleField(object, string));
                continue;
            }
            if (clazz == Float.TYPE) {
                this.realOutput.writeFloat(this.getFloatField(object, string));
                continue;
            }
            if (clazz == Integer.TYPE) {
                this.realOutput.writeInt(this.getIntField(object, string));
                continue;
            }
            if (clazz == Long.TYPE) {
                this.realOutput.writeLong(this.getLongField(object, string));
                continue;
            }
            if (clazz == Short.TYPE) {
                this.realOutput.writeShort(this.getShortField(object, string));
                continue;
            }
            this.writeObject(this.getObjectField(object, string, TypeSignature.getEncodingOfClass(clazz)));
        }
    }

    private void setBlockDataMode(boolean bl) {
        this.writeDataAsBlocks = bl;
        this.dataOutput = bl ? this.blockDataOutput : this.realOutput;
    }

    private void callWriteMethod(Object object) throws IOException {
        Class clazz = object.getClass();
        try {
            Class[] classArray = new Class[]{ObjectOutputStream.class$("java.io.ObjectOutputStream")};
            Method method = ObjectOutputStream.getMethod(clazz, "writeObject", classArray);
            if (method == null) {
                return;
            }
            Object[] objectArray = new Object[]{this};
            method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Exception thrown from writeObject() on " + clazz + ": " + throwable.getClass().getName());
        }
        catch (Exception exception) {
            throw new IOException("Failure invoking writeObject() on " + clazz + ": " + exception.getClass().getName());
        }
    }

    private boolean getBooleanField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            boolean bl = field.getBoolean(object);
            return bl;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private byte getByteField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            byte by = field.getByte(object);
            return by;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private char getCharField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            char c = field.getChar(object);
            return c;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private double getDoubleField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            double d = field.getDouble(object);
            return d;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private float getFloatField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            float f = field.getFloat(object);
            return f;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private int getIntField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            int n = field.getInt(object);
            return n;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private long getLongField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            long l = field.getLong(object);
            return l;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private short getShortField(Object object, String string) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            short s = field.getShort(object);
            return s;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private Object getObjectField(Object object, String string, String string2) throws IOException {
        try {
            Class clazz = object.getClass();
            Field field = ObjectOutputStream.getField(clazz, string);
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private static native Field getField(Class var0, String var1) throws NoSuchFieldException;

    private static native Method getMethod(Class var0, String var1, Class[] var2) throws NoSuchMethodException;

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract void put(String var1, Object var2) throws IOException, IllegalArgumentException;

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

