/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import gnu.java.lang.reflect.TypeSignature;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.ValidatorAndPriority;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static final Class[] readObjectParams = new Class[]{ObjectInputStream.class$("java.io.ObjectInputStream")};
    private DataInputStream realInputStream;
    private DataInputStream dataInputStream;
    private DataInputStream blockDataInput;
    private int blockDataPosition;
    private int blockDataBytes;
    private byte[] blockData;
    private boolean useSubclassMethod;
    private int nextOID;
    private boolean resolveEnabled;
    private Hashtable objectLookupTable;
    private Object currentObject;
    private ObjectStreamClass currentObjectStreamClass;
    private boolean readDataFromBlock;
    private boolean isDeserializing;
    private boolean fieldsAlreadyRead;
    private Vector validators;
    private static boolean dump;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ObjectInputStream(InputStream inputStream) throws StreamCorruptedException, IOException {
        this.resolveEnabled = false;
        this.isDeserializing = false;
        this.blockDataPosition = 0;
        this.blockDataBytes = 0;
        this.blockData = new byte[1024];
        this.blockDataInput = new DataInputStream(this);
        this.realInputStream = new DataInputStream(inputStream);
        this.nextOID = 0x7E0000;
        this.objectLookupTable = new Hashtable();
        this.validators = new Vector();
        this.setBlockDataMode(true);
        this.readStreamHeader();
    }

    public final Object readObject() throws IOException, ClassNotFoundException {
        Object object;
        if (this.useSubclassMethod) {
            return this.readObjectOverride();
        }
        boolean bl = this.isDeserializing;
        if (!bl) {
            this.setBlockDataMode(false);
        }
        this.isDeserializing = true;
        byte by = this.realInputStream.readByte();
        this.dumpElement("MARKER: 0x" + Integer.toHexString(by) + " ");
        switch (by) {
            case 119: 
            case 122: {
                if (by == 122) {
                    this.dumpElementln("BLOCKDATALONG");
                } else {
                    this.dumpElementln("BLOCKDATA");
                }
                this.readNextBlock(by);
                throw new StreamCorruptedException("Unexpected blockData");
            }
            case 112: {
                this.dumpElementln("NULL");
                object = null;
                break;
            }
            case 113: {
                this.dumpElement("REFERENCE ");
                Integer n = new Integer(this.realInputStream.readInt());
                this.dumpElementln(Integer.toHexString(n));
                object = ((ObjectIdentityWrapper)this.objectLookupTable.get((Object)n)).object;
                break;
            }
            case 118: {
                this.dumpElementln("CLASS");
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class clazz = objectStreamClass.forClass();
                this.assignNewHandle(clazz);
                object = clazz;
                break;
            }
            case 114: {
                this.dumpElement("CLASSDESC NAME=");
                String string = this.realInputStream.readUTF();
                this.dumpElement(string + "; UID=");
                long l = this.realInputStream.readLong();
                this.dumpElement(Long.toHexString(l) + "; FLAGS=");
                byte by2 = this.realInputStream.readByte();
                this.dumpElement(Integer.toHexString(by2) + "; FIELD COUNT=");
                int n = this.realInputStream.readShort();
                this.dumpElementln(Short.toString((short)n));
                ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[n];
                ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l, by2, objectStreamFieldArray);
                this.assignNewHandle(objectStreamClass);
                for (int i = 0; i < n; ++i) {
                    this.dumpElement("  TYPE CODE=");
                    char c = (char)this.realInputStream.readByte();
                    this.dumpElement(c + "; FIELD NAME=");
                    String string2 = this.realInputStream.readUTF();
                    this.dumpElementln(string2);
                    String string3 = c == 'L' || c == '[' ? (String)this.readObject() : String.valueOf(c);
                    objectStreamFieldArray[i] = new ObjectStreamField(string2, TypeSignature.getClassForEncoding(string3));
                }
                Class clazz = this.resolveClass(objectStreamClass);
                objectStreamClass.setClass(clazz);
                this.setBlockDataMode(false);
                if (this.realInputStream.readByte() != 120) {
                    throw new IOException("Data annotated to class was not consumed.");
                }
                this.dumpElementln("ENDBLOCKDATA ");
                objectStreamClass.setSuperclass((ObjectStreamClass)this.readObject());
                object = objectStreamClass;
                break;
            }
            case 116: {
                this.dumpElement("STRING=");
                String string = this.realInputStream.readUTF();
                this.dumpElementln(string);
                object = this.processResolution(string, this.assignNewHandle(string));
                break;
            }
            case 117: {
                this.dumpElementln("ARRAY");
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class clazz = objectStreamClass.forClass().getComponentType();
                this.dumpElement("ARRAY LENGTH=");
                int n = this.realInputStream.readInt();
                this.dumpElementln(n + "; COMPONENT TYPE=" + clazz);
                Object object2 = Array.newInstance(clazz, n);
                int n2 = this.assignNewHandle(object2);
                this.readArrayElements(object2, clazz);
                int n3 = Array.getLength(object2);
                for (int i = 0; i < n3; ++i) {
                    this.dumpElementln("  ELEMENT[" + i + "]=" + Array.get(object2, i).toString());
                }
                object = this.processResolution(object2, n2);
                break;
            }
            case 115: {
                this.dumpElementln("OBJECT");
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
                Class clazz = objectStreamClass.forClass();
                if (!ObjectInputStream.class$("java.io.Serializable").isAssignableFrom(clazz)) {
                    throw new NotSerializableException(clazz + " is not Serializable, and thus cannot be deserialized.");
                }
                if (ObjectInputStream.class$("java.io.Externalizable").isAssignableFrom(clazz)) {
                    boolean bl2;
                    Externalizable externalizable = null;
                    try {
                        externalizable = (Externalizable)clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ClassNotFoundException("Instance of " + clazz + " could not be created");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ClassNotFoundException("Instance of " + clazz + " could not be created because class or zero-argument constructor is not accessible");
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        throw new ClassNotFoundException("Instance of " + clazz + " could not be created because zero-argument constructor is not defined");
                    }
                    int n = this.assignNewHandle(externalizable);
                    boolean bl3 = bl2 = (objectStreamClass.getFlags() & 8) != 0;
                    if (bl2) {
                        this.setBlockDataMode(true);
                    }
                    externalizable.readExternal(this);
                    if (bl2) {
                        this.setBlockDataMode(false);
                    }
                    object = this.processResolution(externalizable, n);
                    break;
                }
                Class clazz2 = clazz.getSuperclass();
                while (ObjectInputStream.class$("java.io.Serializable").isAssignableFrom(clazz2) || Modifier.isAbstract(clazz2.getModifiers())) {
                    clazz2 = clazz2.getSuperclass();
                }
                Object object3 = null;
                object3 = this.newObject(clazz, clazz2);
                if (object3 == null) {
                    throw new ClassNotFoundException("Instance of " + clazz + " could not be created");
                }
                int n = this.assignNewHandle(object3);
                this.currentObject = object3;
                ObjectStreamClass[] objectStreamClassArray = ObjectStreamClass.getObjectStreamClasses(clazz);
                for (int i = 0; i < objectStreamClassArray.length; ++i) {
                    this.currentObjectStreamClass = objectStreamClassArray[i];
                    this.dumpElementln("Reading fields of " + this.currentObjectStreamClass.getName());
                    boolean bl4 = true;
                    try {
                        this.currentObjectStreamClass.forClass().getDeclaredMethod("readObject", readObjectParams);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        bl4 = false;
                    }
                    this.readFields(object3, this.currentObjectStreamClass.fields, bl4, this.currentObjectStreamClass);
                    if (!bl4) continue;
                    this.dumpElement("ENDBLOCKDATA? ");
                    try {
                        if (this.realInputStream.readByte() != 120) {
                            throw new IOException("No end of block data seen for class with readObject (ObjectInputStream) method.");
                        }
                        this.dumpElementln("yes");
                        continue;
                    }
                    catch (EOFException eOFException) {
                        this.dumpElementln("no, got EOFException");
                        continue;
                    }
                    catch (IOException iOException) {
                        this.dumpElementln("no, got IOException");
                    }
                }
                this.currentObject = null;
                this.currentObjectStreamClass = null;
                object = this.processResolution(object3, n);
                break;
            }
            case 121: {
                this.dumpElementln("RESET");
                this.clearHandles();
                object = this.readObject();
                break;
            }
            case 123: {
                this.dumpElement("EXCEPTION=");
                Exception exception = (Exception)this.readObject();
                this.dumpElementln(exception.toString());
                this.clearHandles();
                throw new WriteAbortedException("Exception thrown during writing of stream", exception);
            }
            default: {
                throw new IOException("Unknown marker on stream");
            }
        }
        this.isDeserializing = bl;
        if (!bl) {
            this.setBlockDataMode(true);
            if (this.validators.size() > 0) {
                this.invokeValidators();
            }
        }
        return object;
    }

    public void defaultReadObject() throws NotActiveException, IOException, ClassNotFoundException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultReadObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("defaultReadObject called but fields already read from stream (by defaultReadObject or readFields)");
        }
        this.readFields(this.currentObject, this.currentObjectStreamClass.fields, false, this.currentObjectStreamClass);
        this.fieldsAlreadyRead = true;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("registerValidation called by non-active class and/or object");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("attempt to add a null ObjectInputValidation object");
        }
        this.validators.addElement(new ValidatorAndPriority(objectInputValidation, n));
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        ClassLoader classLoader = ObjectInputStream.currentClassLoader(securityManager);
        return Class.forName(objectStreamClass.getName(), true, classLoader);
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableResolveObject(boolean bl) {
        if (bl && this.getClass().getClassLoader() != null) {
            throw new SecurityException("Untrusted ObjectInputStream subclass attempted to enable object resolution");
        }
        boolean bl2 = this.resolveEnabled;
        this.resolveEnabled = bl;
        return bl2;
    }

    protected void readStreamHeader() throws StreamCorruptedException, IOException {
        this.dumpElement("STREAM MAGIC ");
        if (this.realInputStream.readShort() != -21267) {
            throw new StreamCorruptedException("Invalid stream magic number");
        }
        this.dumpElementln("STREAM VERSION ");
        if (this.realInputStream.readShort() != 5) {
            throw new StreamCorruptedException("Invalid stream version number");
        }
    }

    public int read() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockData[this.blockDataPosition++] & 0xFF;
        }
        return this.realInputStream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition + n2 > this.blockDataBytes) {
                this.readNextBlock();
            }
            System.arraycopy(this.blockData, this.blockDataPosition, byArray, n, n2);
            this.blockDataPosition += n2;
            return n2;
        }
        return this.realInputStream.read(byArray, n, n2);
    }

    public int available() throws IOException {
        if (this.readDataFromBlock) {
            if (this.blockDataPosition >= this.blockDataBytes) {
                this.readNextBlock();
            }
            return this.blockDataBytes - this.blockDataPosition;
        }
        return this.realInputStream.available();
    }

    public void close() throws IOException {
        this.realInputStream.close();
    }

    public boolean readBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dataInputStream.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.dataInputStream.readChar();
    }

    public int readInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public long readLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    public float readFloat() throws IOException {
        return this.dataInputStream.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dataInputStream.readDouble();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dataInputStream.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.dataInputStream.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    public String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    public GetField readFields() throws NotActiveException, ClassNotFoundException, IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("readFields called by non-active class and/or object");
        }
        if (this.fieldsAlreadyRead) {
            throw new NotActiveException("readFields called but fields already read from stream (by defaultReadObject or readFields)");
        }
        ObjectStreamClass objectStreamClass = this.currentObjectStreamClass;
        byte[] byArray = new byte[objectStreamClass.primFieldSize];
        Object[] objectArray = new Object[objectStreamClass.objectFieldCount];
        this.setBlockDataMode(false);
        this.readFully(byArray);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.readObject();
        }
        this.setBlockDataMode(true);
        return new GetField(this, objectArray, byArray, objectStreamClass){
            private /* synthetic */ ObjectInputStream this$0;
            private /* synthetic */ Object[] val$objs;
            private /* synthetic */ byte[] val$prim_field_data;
            private /* synthetic */ ObjectStreamClass val$clazz;
            {
                this.this$0 = objectInputStream;
                this.finit$(objectArray, byArray, objectStreamClass);
            }

            private /* synthetic */ void finit$(Object[] objectArray, byte[] byArray, ObjectStreamClass objectStreamClass) {
                this.val$clazz = objectStreamClass;
                this.val$prim_field_data = byArray;
                this.val$objs = objectArray;
            }

            public ObjectStreamClass getObjectStreamClass() {
                return this.val$clazz;
            }

            public boolean defaulted(String string) throws IOException {
                return this.val$clazz.getField(string) == null;
            }

            public boolean get(String string, boolean bl) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Boolean.TYPE);
                if (objectStreamField == null) {
                    return bl;
                }
                return this.val$prim_field_data[objectStreamField.getOffset()] != 0;
            }

            public char get(String string, char c) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Character.TYPE);
                if (objectStreamField == null) {
                    return c;
                }
                int n = objectStreamField.getOffset();
                return (char)((this.val$prim_field_data[n++] & 0xFF) << 8 | this.val$prim_field_data[n] & 0xFF);
            }

            public byte get(String string, byte by) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Byte.TYPE);
                if (objectStreamField == null) {
                    return by;
                }
                return this.val$prim_field_data[objectStreamField.getOffset()];
            }

            public short get(String string, short s) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Short.TYPE);
                if (objectStreamField == null) {
                    return s;
                }
                int n = objectStreamField.getOffset();
                return (short)(((short)this.val$prim_field_data[n++] & 0xFF) << 8 | (short)this.val$prim_field_data[n] & 0xFF);
            }

            public int get(String string, int n) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Integer.TYPE);
                if (objectStreamField == null) {
                    return n;
                }
                int n2 = objectStreamField.getOffset();
                return (this.val$prim_field_data[n2++] & 0xFF) << 24 | (this.val$prim_field_data[n2++] & 0xFF) << 16 | (this.val$prim_field_data[n2++] & 0xFF) << 8 | this.val$prim_field_data[n2] & 0xFF;
            }

            public long get(String string, long l) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Long.TYPE);
                if (objectStreamField == null) {
                    return l;
                }
                int n = objectStreamField.getOffset();
                return (this.val$prim_field_data[n++] & 0xFF) << 24 | (this.val$prim_field_data[n++] & 0xFF) << 16 | (this.val$prim_field_data[n++] & 0xFF) << 8 | (this.val$prim_field_data[n++] & 0xFF) << 0 | (this.val$prim_field_data[n++] & 0xFF) << 24 | (this.val$prim_field_data[n++] & 0xFF) << 16 | (this.val$prim_field_data[n++] & 0xFF) << 8 | this.val$prim_field_data[n] & 0xFF;
            }

            public float get(String string, float f) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Float.TYPE);
                if (objectStreamField == null) {
                    return f;
                }
                int n = objectStreamField.getOffset();
                return Float.intBitsToFloat((this.val$prim_field_data[n++] & 0xFF) << 24 | (this.val$prim_field_data[n++] & 0xFF) << 16 | (this.val$prim_field_data[n++] & 0xFF) << 8 | this.val$prim_field_data[n] & 0xFF);
            }

            public double get(String string, double d) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, Double.TYPE);
                if (objectStreamField == null) {
                    return d;
                }
                int n = objectStreamField.getOffset();
                return Double.longBitsToDouble((this.val$prim_field_data[n++] & 0xFF) << 24 | (this.val$prim_field_data[n++] & 0xFF) << 16 | (this.val$prim_field_data[n++] & 0xFF) << 8 | (this.val$prim_field_data[n++] & 0xFF) << 0 | (this.val$prim_field_data[n++] & 0xFF) << 24 | (this.val$prim_field_data[n++] & 0xFF) << 16 | (this.val$prim_field_data[n++] & 0xFF) << 8 | this.val$prim_field_data[n] & 0xFF);
            }

            public Object get(String string, Object object) throws IOException {
                ObjectStreamField objectStreamField = this.getField(string, object == null ? null : object.getClass());
                if (objectStreamField == null) {
                    return object;
                }
                return this.val$objs[objectStreamField.getOffset()];
            }

            private ObjectStreamField getField(String string, Class clazz) {
                ObjectStreamField objectStreamField = this.val$clazz.getField(string);
                if (objectStreamField == null) {
                    return null;
                }
                Class clazz2 = objectStreamField.getType();
                if (clazz == clazz2 || clazz == null && !clazz2.isPrimitive()) {
                    return objectStreamField;
                }
                throw new IllegalArgumentException("Field requested is of type " + clazz2.getName() + ", but requested type was " + (clazz == null ? "Object" : clazz.getName()));
            }
        };
    }

    protected ObjectInputStream() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    protected Object readObjectOverride() throws OptionalDataException, IOException, ClassNotFoundException {
        throw new IOException("Subclass of ObjectInputStream must implement readObjectOverride");
    }

    private int assignNewHandle(Object object) {
        this.objectLookupTable.put(new Integer(this.nextOID), new ObjectIdentityWrapper(object));
        return this.nextOID++;
    }

    private Object processResolution(Object object, int n) throws IOException {
        if (object instanceof Serializable) {
            Method method = null;
            try {
                Class[] classArray = new Class[]{};
                method = object.getClass().getDeclaredMethod("readResolve", classArray);
                object = method.invoke(object, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (this.resolveEnabled) {
            object = this.resolveObject(object);
        }
        this.objectLookupTable.put(new Integer(n), new ObjectIdentityWrapper(object));
        return object;
    }

    private void clearHandles() {
        this.objectLookupTable.clear();
        this.nextOID = 0x7E0000;
    }

    private void readNextBlock() throws IOException {
        this.readNextBlock(this.realInputStream.readByte());
    }

    private void readNextBlock(byte by) throws IOException {
        if (by == 119) {
            this.dumpElement("BLOCK DATA SIZE=");
            this.blockDataBytes = this.realInputStream.readUnsignedByte();
            this.dumpElementln(Integer.toString(this.blockDataBytes));
        } else if (by == 122) {
            this.dumpElement("BLOCK DATA LONG SIZE=");
            this.blockDataBytes = this.realInputStream.readInt();
            this.dumpElementln(Integer.toString(this.blockDataBytes));
        } else {
            throw new EOFException("Attempt to read primitive data, but no data block is active.");
        }
        if (this.blockData.length < this.blockDataBytes) {
            this.blockData = new byte[this.blockDataBytes];
        }
        this.realInputStream.readFully(this.blockData, 0, this.blockDataBytes);
        this.blockDataPosition = 0;
    }

    private void readArrayElements(Object object, Class clazz) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = this.realInputStream.readBoolean();
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = this.realInputStream.readByte();
                }
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = this.realInputStream.readChar();
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = this.realInputStream.readDouble();
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = this.realInputStream.readFloat();
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.realInputStream.readInt();
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = this.realInputStream.readLong();
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = this.realInputStream.readShort();
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.readObject();
            }
        }
    }

    private void readFields(Object object, ObjectStreamField[] objectStreamFieldArray, boolean bl, ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (bl) {
            this.fieldsAlreadyRead = false;
            this.setBlockDataMode(true);
            this.callReadMethod(object, objectStreamClass.forClass());
            this.setBlockDataMode(false);
            return;
        }
        ObjectStreamField[] objectStreamFieldArray2 = ObjectStreamClass.lookup((Class)objectStreamClass.forClass()).fields;
        String string = null;
        Class clazz = null;
        ObjectStreamField objectStreamField = null;
        ObjectStreamField objectStreamField2 = null;
        int n = 0;
        int n2 = 0;
        while (n < objectStreamFieldArray.length && n2 < objectStreamFieldArray2.length) {
            Object object2;
            int n3;
            boolean bl2 = false;
            boolean bl3 = true;
            if (n == objectStreamFieldArray.length) {
                bl2 = true;
            } else {
                objectStreamField = objectStreamFieldArray[n];
                clazz = objectStreamField.getType();
            }
            if (n2 == objectStreamFieldArray2.length) {
                bl3 = false;
            } else {
                objectStreamField2 = objectStreamFieldArray2[n2];
                clazz = objectStreamField2.getType();
                string = objectStreamField2.getName();
            }
            if (bl3 && !bl2) {
                n3 = objectStreamField2.compareTo(objectStreamField);
                if (n3 < 0) {
                    bl2 = true;
                    ++n2;
                } else if (n3 > 0) {
                    bl3 = false;
                    ++n;
                } else {
                    ++n2;
                    ++n;
                }
            }
            if (clazz == Boolean.TYPE) {
                int n4 = n3 = bl2 ? 0 : (int)(this.realInputStream.readBoolean() ? 1 : 0);
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + (n3 != 0));
                }
                if (!bl3) continue;
                this.setBooleanField(object, string, n3 != 0);
                continue;
            }
            if (clazz == Byte.TYPE) {
                int n5 = n3 = bl2 ? 0 : (int)this.realInputStream.readByte();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + n3);
                }
                if (!bl3) continue;
                this.setByteField(object, string, (byte)n3);
                continue;
            }
            if (clazz == Character.TYPE) {
                int n6 = n3 = bl2 ? 0 : (int)this.realInputStream.readChar();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + (char)n3);
                }
                if (!bl3) continue;
                this.setCharField(object, string, (char)n3);
                continue;
            }
            if (clazz == Double.TYPE) {
                double d;
                double d2 = d = bl2 ? 0.0 : this.realInputStream.readDouble();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + d);
                }
                if (!bl3) continue;
                this.setDoubleField(object, string, d);
                continue;
            }
            if (clazz == Float.TYPE) {
                float f;
                float f2 = f = bl2 ? 0.0f : this.realInputStream.readFloat();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + f);
                }
                if (!bl3) continue;
                this.setFloatField(object, string, f);
                continue;
            }
            if (clazz == Integer.TYPE) {
                int n7 = n3 = bl2 ? 0 : this.realInputStream.readInt();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + n3);
                }
                if (!bl3) continue;
                this.setIntField(object, string, n3);
                continue;
            }
            if (clazz == Long.TYPE) {
                long l;
                long l2 = l = bl2 ? 0L : this.realInputStream.readLong();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + l);
                }
                if (!bl3) continue;
                this.setLongField(object, string, l);
                continue;
            }
            if (clazz == Short.TYPE) {
                int n8 = n3 = bl2 ? 0 : this.realInputStream.readShort();
                if (!bl2 && bl3) {
                    this.dumpElementln("  " + string + ": " + n3);
                }
                if (!bl3) continue;
                this.setShortField(object, string, (short)n3);
                continue;
            }
            Object object3 = object2 = bl2 ? null : this.readObject();
            if (!bl3) continue;
            this.setObjectField(object, string, objectStreamField2.getTypeString(), object2);
        }
    }

    private void setBlockDataMode(boolean bl) {
        this.readDataFromBlock = bl;
        this.dataInputStream = bl ? this.blockDataInput : this.realInputStream;
    }

    private Object newObject(Class clazz, Class clazz2) {
        try {
            Object object = this.allocateObject(clazz);
            this.callConstructor(clazz2, object);
            return object;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    private void invokeValidators() throws InvalidObjectException {
        Object[] objectArray = new Object[this.validators.size()];
        this.validators.copyInto(objectArray);
        Arrays.sort(objectArray);
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ObjectInputValidation)objectArray[i]).validateObject();
            }
            Object var2_3 = null;
            this.validators.removeAllElements();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.validators.removeAllElements();
            throw throwable;
        }
    }

    private static ClassLoader currentClassLoader(SecurityManager securityManager) {
        return ClassLoader.getSystemClassLoader();
    }

    private static native Field getField(Class var0, String var1) throws NoSuchFieldException;

    private static native Method getMethod(Class var0, String var1, Class[] var2) throws NoSuchMethodException;

    private void callReadMethod(Object object, Class clazz) throws IOException {
        try {
            Class[] classArray = new Class[]{ObjectInputStream.class$("java.io.ObjectInputStream")};
            Method method = ObjectInputStream.getMethod(clazz, "readObject", classArray);
            if (method == null) {
                return;
            }
            Object[] objectArray = new Object[]{this};
            method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Exception thrown from readObject() on " + clazz + ": " + throwable.getClass().getName());
        }
        catch (Exception exception) {
            throw new IOException("Failure invoking readObject() on " + clazz + ": " + exception.getClass().getName());
        }
    }

    private native Object allocateObject(Class var1) throws InstantiationException;

    private native void callConstructor(Class var1, Object var2);

    private void setBooleanField(Object object, String string, boolean bl) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setBoolean(object, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setByteField(Object object, String string, byte by) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setByte(object, by);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCharField(Object object, String string, char c) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setChar(object, c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setDoubleField(Object object, String string, double d) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setDouble(object, d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setFloatField(Object object, String string, float f) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setFloat(object, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setIntField(Object object, String string, int n) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setInt(object, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setLongField(Object object, String string, long l) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setLong(object, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setShortField(Object object, String string, short s) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.setShort(object, s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setObjectField(Object object, String string, String string2, Object object2) {
        try {
            Class clazz = object.getClass();
            Field field = ObjectInputStream.getField(clazz, string);
            field.set(object, object2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dumpElement(String string) {
    }

    private void dumpElementln(String string) {
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

