/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    int lineNumber;

    public LineNumberReader(Reader reader) {
        super(reader, 8192);
    }

    public LineNumberReader(Reader reader, int n) {
        super(reader, n);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    private static int countLines(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = cArray[i + n];
            if (n5 == 10 && n4 != 13 || n5 == 13) {
                ++n3;
            }
            n4 = n5;
        }
        return n3;
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray;
            try {
                if (this.pos + n > this.limit) {
                    int n2 = this.pos > 0 && this.buffer[this.pos - 1] == '\r' ? 1 : 0;
                    cArray = this.buffer;
                    if (n > this.limit) {
                        this.buffer = new char[n2 + n];
                    }
                    int n3 = this.pos - n2;
                    this.limit -= n3;
                    System.arraycopy(cArray, n3, this.buffer, 0, this.limit);
                    this.pos = n2;
                }
                this.markPos = this.pos;
            }
            finally {
                cArray = null;
            }
            return;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.markPos < 0) {
                    throw new IOException("mark never set or invalidated");
                }
                if (this.markPos > 0 && this.pos > this.markPos && this.buffer[this.markPos - 1] == '\r' && this.buffer[this.markPos] == '\n') {
                    this.lineNumber += -1;
                }
                this.lineNumber -= LineNumberReader.countLines(this.buffer, this.pos, this.markPos);
                this.pos = this.markPos;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                int n;
                this.skipRedundantLF();
                if (this.pos >= this.limit) {
                    if (this.markPos >= 0 && this.limit == this.buffer.length) {
                        this.markPos = -1;
                    }
                    if (this.markPos <= 0) {
                        this.limit = 0;
                        this.pos = 0;
                    }
                    if ((n = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) <= 0) {
                        return -1;
                    }
                    this.limit += n;
                }
                if ((n = this.buffer[this.pos++]) != 13) {
                    if (n != 10) return n;
                }
                ++this.lineNumber;
                return 10;
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                throw throwable;
            }
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            int n3;
            try {
                int n4 = this.read();
                if (n4 < 0) {
                    int n5 = -1;
                    Object var7_9 = null;
                    return n5;
                }
                int n6 = n;
                cArray[n++] = (char)n4;
                if (this.buffer[this.pos - 1] == '\r' && this.pos < this.limit && this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
                while (true) {
                    int n7;
                    int n8 = --n2;
                    --n2;
                    if (n8 <= 0 || this.pos >= this.limit) break;
                    if ((n7 = this.buffer[this.pos++]) == 13) {
                        ++this.lineNumber;
                        n7 = 10;
                        if (this.pos < this.limit && this.buffer[this.pos] == '\n') {
                            ++this.pos;
                        }
                    } else if (n7 == 10) {
                        ++this.lineNumber;
                    }
                    cArray[n++] = n7;
                }
                n3 = n - n6;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                throw throwable;
            }
            Object var7_11 = null;
            return n3;
        }
    }

    private void skipRedundantLF() throws IOException {
        if (this.pos > 0 && this.buffer[this.pos - 1] == '\r') {
            if (this.pos < this.limit) {
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            } else {
                if (this.pos >= this.buffer.length) {
                    this.markPos = -1;
                }
                this.limit = 0;
                this.pos = 0;
                int n = this.read();
                if (n >= 0 && n != 10) {
                    this.pos += -1;
                }
            }
        }
    }

    public String readLine() throws IOException {
        char c;
        int n = this.lineNumber;
        this.skipRedundantLF();
        String string = super.readLine();
        if (this.pos > this.limit) {
            this.pos += -1;
        }
        if (this.pos > 0 && ((c = this.buffer[this.pos - 1]) == '\n' || c == '\r')) {
            this.lineNumber = n + 1;
        }
        return string;
    }

    public long skip(long l) throws IOException {
        int n;
        if (l <= 0L) {
            return 0L;
        }
        long l2 = l;
        while ((n = this.read()) >= 0) {
            l2 += (long)-1;
            if (n == 10 || n == 13) {
                ++this.lineNumber;
            } else {
                char c;
                long l3 = (long)this.pos + l2;
                if ((long)this.limit < l3) {
                    l3 = this.limit;
                }
                int n2 = this.pos;
                while ((long)n2 < l3 && (c = this.buffer[n2]) != '\n' && c != '\r') {
                    ++n2;
                }
                l2 -= (long)(n2 - this.pos);
                this.pos = n2;
            }
            if (l2 > 0L) continue;
        }
        return l - l2;
    }
}

