/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.BytesToUnicode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    BufferedInputStream in;
    char[] work;
    int wpos;
    int wcount;
    BytesToUnicode converter;

    public InputStreamReader(InputStream inputStream) {
        this(inputStream, BytesToUnicode.getDefaultDecoder());
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, BytesToUnicode.getDecoder(string));
    }

    private InputStreamReader(InputStream inputStream, BytesToUnicode bytesToUnicode) {
        this.in = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.lock = inputStream;
        this.converter = bytesToUnicode;
        this.converter.setInput(this.in.buf, 0, 0);
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = null;
                this.work = null;
                this.wcount = 0;
                this.wpos = 0;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public String getEncoding() {
        return this.converter.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wpos < this.wcount) {
                    return true;
                }
                if (this.work == null) {
                    this.work = new char[100];
                    this.wpos = 0;
                    this.wcount = 0;
                }
                do {
                    if (this.in.available() <= 0) {
                        return false;
                    }
                    this.in.mark(1);
                    int n = this.in.read();
                    if (n < 0) {
                        return true;
                    }
                    this.in.reset();
                    this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
                    this.wpos = 0;
                    this.wcount = this.converter.read(this.work, 0, this.work.length);
                    this.in.skip(this.converter.inpos - this.in.pos);
                } while (this.wcount <= 0);
                return true;
            }
            catch (Throwable throwable) {
                Object var4_10 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                int n3;
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                int n4 = this.wcount - this.wpos;
                if (n4 > 0) {
                    if (n2 > n4) {
                        n2 = n4;
                    }
                    System.arraycopy(this.work, this.wpos, cArray, n, n2);
                    this.wpos += n2;
                    return n2;
                }
                if (n2 == 0) {
                    return 0;
                }
                do {
                    this.in.mark(1);
                    int n5 = this.in.read();
                    if (n5 < 0) {
                        return -1;
                    }
                    this.in.reset();
                    this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
                    n3 = this.converter.read(cArray, n, n2);
                    this.in.skip(this.converter.inpos - this.in.pos);
                } while (n3 <= 0);
                return n3;
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                int n = this.wcount - this.wpos;
                if (n > 0) {
                    return this.work[this.wpos++];
                }
                if (this.work == null) {
                    this.work = new char[100];
                    this.wpos = 0;
                    this.wcount = 0;
                } else if (n == 0) {
                    this.wpos = 0;
                    this.wcount = 0;
                }
                int n2 = this.read(this.work, this.wpos, this.work.length - this.wpos);
                if (n2 <= 0) {
                    return -1;
                }
                this.wcount = this.wpos + n2;
                return this.work[this.wpos++];
            }
            catch (Throwable throwable) {
                Object var4_11 = null;
                throw throwable;
            }
        }
    }
}

