/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    public FileOutputStream(String string, boolean bl) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        this.fd = new FileDescriptor(string, bl ? 4 : 2);
    }

    public FileOutputStream(String string) throws IOException {
        this(string, false);
    }

    public FileOutputStream(File file) throws IOException {
        this(file.getPath(), false);
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    protected void finalize() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public void write(int n) throws IOException {
        this.fd.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.fd.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.fd.write(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }
}

