/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    public FileInputStream(String string) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        this.fd = new FileDescriptor(string, 1);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    public int available() throws IOException {
        return this.fd.available();
    }

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.fd.finalize();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public int read() throws IOException {
        return this.fd.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.fd.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.fd.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.fd.seek(l, 1);
    }
}

