/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.runtime.FileDeleter;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class File
implements Serializable,
Comparable {
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    static final String tmpdir = System.getProperty("java.io.tmpdir");
    static int maxPathLen;
    static boolean caseSensitive;
    static String dupSeparator;
    private String path;
    private static long counter;
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int EXISTS = 2;
    private static final int DIRECTORY = 0;
    private static final int ISFILE = 1;
    private static final int ISHIDDEN = 2;
    private static final int MODIFIED = 0;
    private static final int LENGTH = 1;
    private static final long serialVersionUID = 301077366599181567L;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean canRead() {
        this.checkRead();
        return this._access(0);
    }

    public boolean canWrite() {
        this.checkWrite();
        return this._access(1);
    }

    private native boolean performCreate() throws IOException;

    public boolean createNewFile() throws IOException {
        this.checkWrite();
        return this.performCreate();
    }

    private native boolean performDelete();

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        String string = this.path;
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        return this.performDelete();
    }

    public boolean equals(Object object) {
        if (!(object instanceof File)) {
            return false;
        }
        File file = (File)object;
        if (caseSensitive) {
            return this.path.equals(file.path);
        }
        return this.path.equalsIgnoreCase(file.path);
    }

    public boolean exists() {
        this.checkRead();
        return this._access(2);
    }

    public File(String string) {
        this.path = this.normalizePath(string);
    }

    private String normalizePath(String string) {
        int n = string.indexOf(dupSeparator);
        int n2 = string.length();
        if (dupSeparator == "\\" && n == 0) {
            n = string.indexOf(dupSeparator, 1);
        }
        if (n == -1) {
            if (n2 > 1 && string.charAt(n2 - 1) == separatorChar) {
                return string.substring(0, n2 - 1);
            }
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n3, n));
            while (string.charAt(n) == separatorChar) {
                if (++n != n2) continue;
                return stringBuffer.toString();
            }
            stringBuffer.append(separatorChar);
            n3 = n;
            n = string.indexOf(dupSeparator, n3);
        }
        int n4 = n2 > 1 && string.charAt(n2 - 1) == separatorChar ? n2 - 1 : n2;
        stringBuffer.append(string.substring(n3, n4));
        return stringBuffer.toString();
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string != null && string.length() > 0 ? (string.charAt(string.length() - 1) == separatorChar || string2.length() == 0 ? this.normalizePath(string + string2) : this.normalizePath(string + separatorChar + string2)) : this.normalizePath(string2);
    }

    public File(File file, String string) {
        this(file == null ? null : file.path, string);
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        return System.getProperty("user.dir") + separatorChar + this.path;
    }

    public File getAbsoluteFile() throws IOException {
        return new File(this.getAbsolutePath());
    }

    public native String getCanonicalPath() throws IOException;

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getName() {
        int n = this.path.lastIndexOf(separatorChar);
        return this.path.substring(n + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n == -1) {
            return null;
        }
        return this.path.substring(0, n);
    }

    public File getParentFile() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        if (caseSensitive) {
            return this.path.hashCode() ^ 0x12D591;
        }
        return this.path.toLowerCase().hashCode() ^ 0x12D591;
    }

    public native boolean isAbsolute();

    public boolean isDirectory() {
        this.checkRead();
        return this._stat(0);
    }

    public boolean isFile() {
        this.checkRead();
        return this._stat(1);
    }

    public boolean isHidden() {
        this.checkRead();
        return this._stat(2);
    }

    public long lastModified() {
        this.checkRead();
        return this.attr(0);
    }

    public long length() {
        this.checkRead();
        return this.attr(1);
    }

    private final native Object[] performList(FilenameFilter var1, FileFilter var2, Class var3);

    public String[] list(FilenameFilter filenameFilter) {
        this.checkRead();
        return (String[])this.performList(filenameFilter, null, File.class$("java.lang.String"));
    }

    public String[] list() {
        this.checkRead();
        return (String[])this.performList(null, null, File.class$("java.lang.String"));
    }

    public File[] listFiles() {
        this.checkRead();
        return (File[])this.performList(null, null, File.class$("java.io.File"));
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        this.checkRead();
        return (File[])this.performList(filenameFilter, null, File.class$("java.io.File"));
    }

    public File[] listFiles(FileFilter fileFilter) {
        this.checkRead();
        return (File[])this.performList(null, fileFilter, File.class$("java.io.File"));
    }

    public String toString() {
        return this.path;
    }

    public URL toURL() throws MalformedURLException {
        return new URL("file:" + this.path + (this.isDirectory() ? "/" : ""));
    }

    private final native boolean performMkdir();

    public boolean mkdir() {
        this.checkWrite();
        return this.performMkdir();
    }

    private static boolean mkdirs(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getPath();
        String string2 = file.getParent();
        if (string2 != null) {
            file.path = string2;
            if (!File.mkdirs(file)) {
                return false;
            }
            file.path = string;
        }
        return file.mkdir();
    }

    public boolean mkdirs() {
        this.checkWrite();
        if (this.isDirectory()) {
            return false;
        }
        return File.mkdirs(new File(this.path));
    }

    private static synchronized String nextValue() {
        return Long.toString(counter++, 36);
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        Object object;
        if (file == null) {
            object = tmpdir;
            if (object == null) {
                throw new IOException("Cannot determine system temporary directory");
            }
            file = new File((String)object);
            if (!file.exists()) {
                throw new IOException("System temporary directory " + file.getName() + " does not exist.");
            }
            if (!file.isDirectory()) {
                throw new IOException("System temporary directory " + file.getName() + " is not really a directory.");
            }
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix too short: " + string);
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (string.length() + 6 + string2.length() > maxPathLen) {
            int n = 0;
            if (string2.charAt(0) == '.') {
                n = 4;
            }
            string2 = string2.substring(0, n);
            if (string.length() + 6 + n > maxPathLen) {
                string = string.substring(0, maxPathLen - 6 - n);
            }
        }
        for (int i = 0; i < 100; ++i) {
            String string3 = "ZZZZZZ" + File.nextValue();
            String string4 = string + string3.substring(string3.length() - 6) + string2;
            try {
                object = new File(file, string4);
                if (!((File)object).createNewFile()) continue;
                return object;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IOException("cannot create temporary file");
    }

    private native boolean performSetReadOnly();

    public boolean setReadOnly() {
        this.checkWrite();
        return this.performSetReadOnly();
    }

    private static native File[] performListRoots();

    public static File[] listRoots() {
        File[] fileArray = File.performListRoots();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n = fileArray.length;
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    securityManager.checkRead(fileArray[i].path);
                    continue;
                }
                catch (SecurityException securityException) {
                    fileArray[i] = null;
                    --n;
                }
            }
            if (n != fileArray.length) {
                File[] fileArray2 = new File[n];
                int n2 = 0;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i] == null) continue;
                    fileArray2[n2++] = fileArray[i];
                }
                fileArray = fileArray2;
            }
        }
        return fileArray;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    public int compareTo(File file) {
        if (caseSensitive) {
            return this.path.compareTo(file.path);
        }
        return this.path.compareToIgnoreCase(file.path);
    }

    public int compareTo(Object object) {
        File file = (File)object;
        return this.compareTo(file);
    }

    private native boolean performRenameTo(File var1);

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        String string = this.getName();
        String string2 = file.getName();
        if (securityManager != null) {
            securityManager.checkWrite(string);
            securityManager.checkWrite(string2);
        }
        return this.performRenameTo(file);
    }

    private native boolean performSetLastModified(long var1);

    public boolean setLastModified(long l) {
        this.checkWrite();
        return this.performSetLastModified(l);
    }

    private static native void init_native();

    private void checkWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
    }

    private void checkRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
    }

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.getName());
        }
        FileDeleter.add(this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        char c = objectInputStream.readChar();
        if (c != separatorChar) {
            this.path = this.path.replace(c, separatorChar);
        }
    }

    private final native long attr(int var1);

    private final native boolean _access(int var1);

    private final native boolean _stat(int var1);

    static {
        dupSeparator = separator + separator;
        File.init_native();
        counter = Double.doubleToLongBits(Math.random());
    }
}

