/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += n2 - n;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public final void writeShort(int n) throws IOException {
        this.write((byte)(n >> 8) & 0xFFFFFFFF);
        this.write((byte)n & 0xFFFFFFFF);
    }

    public final void writeChar(int n) throws IOException {
        this.write((byte)(n >> 8) & 0xFFFFFFFF);
        this.write((byte)n & 0xFFFFFFFF);
    }

    public final void writeInt(int n) throws IOException {
        this.write((byte)(n >> 24) & 0xFFFFFFFF);
        this.write((byte)(n >> 16) & 0xFFFFFFFF);
        this.write((byte)(n >> 8) & 0xFFFFFFFF);
        this.write((byte)n & 0xFFFFFFFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((byte)(l >> 56) & 0xFFFFFFFF);
        this.write((byte)(l >> 48) & 0xFFFFFFFF);
        this.write((byte)(l >> 40) & 0xFFFFFFFF);
        this.write((byte)(l >> 32) & 0xFFFFFFFF);
        this.write((byte)(l >> 24) & 0xFFFFFFFF);
        this.write((byte)(l >> 16) & 0xFFFFFFFF);
        this.write((byte)(l >> 8) & 0xFFFFFFFF);
        this.write((byte)l & 0xFFFFFFFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public final void writeUTF(String string) throws IOException {
        char c;
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2 && n3 <= 65535; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(n3);
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                this.write(0xC0 | 0x1F & c >> 6);
                this.write(0x80 | 0x3F & c);
                continue;
            }
            this.write(0xE0 | 0xF & c >> 12);
            this.write(0x80 | 0x3F & c >> 6);
            this.write(0x80 | 0x3F & c);
        }
    }
}

