/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    boolean ignoreInitialNewline;

    private /* synthetic */ void finit$() {
        this.ignoreInitialNewline = false;
    }

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
        this.finit$();
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final char readChar() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (char)(n << 8 | n2 & 0xFF);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    public final int readInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    public final String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        block0: while (true) {
            int n = 0;
            char c = ' ';
            boolean bl = true;
            while (bl) {
                bl = false;
                n = this.in.read();
                if (n < 0) {
                    if (stringBuffer.length() > 0) {
                        return stringBuffer.toString();
                    }
                    return null;
                }
                c = (char)n;
                if ((c = (char)(c & 0xFF)) != 10) continue;
                if (!this.ignoreInitialNewline) break block0;
                this.ignoreInitialNewline = false;
                bl = true;
            }
            if (c == '\r') {
                int n2 = 0;
                int n3 = 32;
                if (this.in instanceof BufferedInputStream) {
                    n2 = this.in.read();
                    n3 = (char)(n2 & 0xFF);
                    if (n3 == 10 || n2 < 0) break;
                    BufferedInputStream bufferedInputStream = (BufferedInputStream)this.in;
                    if (bufferedInputStream.pos <= 0) break;
                    bufferedInputStream.pos += -1;
                    break;
                }
                if (this.markSupported()) {
                    n2 = this.in.read();
                    n3 = (char)(n2 & 0xFF);
                    if (n3 == 10 || n2 < 0) break;
                    this.mark(1);
                    if ((this.in.read() & 0xFF) == 10) break;
                    this.reset();
                    break;
                }
                this.ignoreInitialNewline = true;
                break;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return "";
    }

    public final long readLong() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        int n5 = this.in.read();
        int n6 = this.in.read();
        int n7 = this.in.read();
        int n8 = this.in.read();
        if (n8 < 0) {
            throw new EOFException();
        }
        return (long)(n & 0xFF) << 56 | (long)(n2 & 0xFF) << 48 | (long)(n3 & 0xFF) << 40 | (long)(n4 & 0xFF) << 32 | (long)(n5 & 0xFF) << 24 | (long)(n6 & 0xFF) << 16 | (long)(n7 & 0xFF) << 8 | (long)(n8 & 0xFF);
    }

    public final short readShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)((short)n << 8 | (short)n2 & 0xFF);
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        byte[] byArray = new byte[n];
        StringBuffer stringBuffer = new StringBuffer();
        dataInput.readFully(byArray, 0, n);
        int n2 = 0;
        while (n2 < n) {
            if ((byArray[n2] & 0x80) == 0) {
                stringBuffer.append((char)(byArray[n2++] & 0xFF));
                continue;
            }
            if ((byArray[n2] & 0xE0) == 192) {
                if (n2 + 1 >= n || (byArray[n2 + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                stringBuffer.append((char)((byArray[n2++] & 0x1F) << 6 | byArray[n2++] & 0x3F));
                continue;
            }
            if ((byArray[n2] & 0xF0) == 224) {
                if (n2 + 2 >= n || (byArray[n2 + 1] & 0xC0) != 128 || (byArray[n2 + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                stringBuffer.append((char)((byArray[n2++] & 0xF) << 12 | (byArray[n2++] & 0x3F) << 6 | byArray[n2++] & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }

    public final int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }
}

