/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos;
    protected int count;

    public CharArrayReader(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public CharArrayReader(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > cArray.length) {
            throw new IllegalArgumentException();
        }
        this.buf = cArray;
        this.count = n + n2;
        if (this.count > this.buf.length) {
            this.count = this.buf.length;
        }
        this.markedPos = this.pos = n;
    }

    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.buf = null;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                this.markedPos = this.pos;
            }
            finally {
                Object var4_3 = null;
            }
            return;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                if (this.pos < 0) {
                    throw new ArrayIndexOutOfBoundsException(this.pos);
                }
                if (this.pos < this.count) {
                    int n2 = this.buf[this.pos++] & 0xFFFF;
                    Object var4_4 = null;
                    return n2;
                }
                n = -1;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
            Object var4_5 = null;
            return n;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3;
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                if (this.pos >= this.count) {
                    int n4 = -1;
                    Object var7_7 = null;
                    return n4;
                }
                int n5 = Math.min(this.count - this.pos, n2);
                System.arraycopy(this.buf, this.pos, cArray, n, n5);
                this.pos += n5;
                n3 = n5;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                throw throwable;
            }
            Object var7_8 = null;
            return n3;
        }
    }

    public boolean ready() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return this.pos < this.count;
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                this.pos = this.markedPos;
            }
            finally {
                Object var3_2 = null;
            }
            return;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("Stream closed");
                }
                long l2 = Math.min((long)(this.count - this.pos), l < 0L ? 0L : l);
                this.pos += (int)l2;
                long l3 = l2;
                Object var5_6 = null;
                return l3;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }
}

