/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos;
    protected int marklimit;

    private /* synthetic */ void finit$() {
        this.count = 0;
        this.pos = 0;
        this.markpos = -1;
        this.marklimit = 0;
    }

    public BufferedInputStream(InputStream inputStream) {
        this(inputStream, 2048);
    }

    public BufferedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.finit$();
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + super.available();
    }

    public void close() throws IOException {
        this.buf = null;
        super.close();
    }

    public synchronized void mark(int n) {
        this.marklimit = n;
        this.markpos = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        if (this.markpos >= 0 && this.pos - this.markpos > this.marklimit) {
            this.markpos = -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.pos >= this.count && !this.refill()) {
            return -1;
        }
        int n3 = Math.min(this.count - this.pos, n2);
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        if (this.markpos >= 0 && this.pos - this.markpos > this.marklimit) {
            this.markpos = -1;
        }
        return n3;
    }

    public synchronized void reset() throws IOException {
        if (this.markpos < 0) {
            throw new IOException();
        }
        this.pos = this.markpos;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = l;
        while (l > 0L) {
            if (this.pos >= this.count && !this.refill()) {
                if (l < l2) break;
                return -1;
            }
            int n = (int)Math.min((long)(this.count - this.pos), l);
            this.pos += n;
            l -= (long)n;
            if (this.markpos < 0 || this.pos - this.markpos <= this.marklimit) continue;
            this.markpos = -1;
        }
        return l2 - l;
    }

    private boolean refill() throws IOException {
        if (this.markpos < 0) {
            this.pos = 0;
            this.count = 0;
        } else if (this.markpos > 0) {
            System.arraycopy(this.buf, this.markpos, this.buf, 0, this.count - this.markpos);
            this.count -= this.markpos;
            this.pos -= this.markpos;
            this.markpos = 0;
        } else if (this.marklimit >= this.buf.length) {
            byte[] byArray = new byte[this.marklimit + 1];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        int n = super.read(this.buf, this.count, this.buf.length - this.count);
        if (n < 0) {
            return false;
        }
        this.count += n;
        return true;
    }
}

