/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VetoableChangeSupport
implements Serializable {
    transient Hashtable propertyListeners;
    transient Vector listeners;
    Hashtable children;
    Object source;
    int vetoableChangeSupportSerializedDataVersion;
    private static final long serialVersionUID = -5090210921595982017L;

    private /* synthetic */ void finit$() {
        this.propertyListeners = new Hashtable();
        this.listeners = new Vector();
        this.vetoableChangeSupportSerializedDataVersion = 2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.children = this.propertyListeners.isEmpty() ? null : this.propertyListeners;
        objectOutputStream.defaultWriteObject();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)enumeration.nextElement();
            if (!(vetoableChangeListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(vetoableChangeListener);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        VetoableChangeListener vetoableChangeListener;
        objectInputStream.defaultReadObject();
        Hashtable hashtable = this.propertyListeners = this.children == null ? new Hashtable() : this.children;
        while ((vetoableChangeListener = (VetoableChangeListener)objectInputStream.readObject()) != null) {
            this.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public VetoableChangeSupport(Object object) {
        this.finit$();
        this.source = object;
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.listeners.addElement(vetoableChangeListener);
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector vector = (Vector)this.propertyListeners.get(string);
                try {
                    vector.addElement(vetoableChangeListener);
                }
                catch (NullPointerException nullPointerException) {
                    vector = new Vector();
                    vector.addElement(vetoableChangeListener);
                    this.propertyListeners.put(string, vector);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.listeners.removeElement(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector vector = (Vector)this.propertyListeners.get(string);
                try {
                    vector.removeElement(vetoableChangeListener);
                    if (vector.size() == 0) {
                        this.propertyListeners.remove(string);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        int n;
        try {
            for (n = 0; n < this.listeners.size(); ++n) {
                ((VetoableChangeListener)this.listeners.elementAt(n)).vetoableChange(propertyChangeEvent);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue());
            for (int i = 0; i < n; ++i) {
                try {
                    ((VetoableChangeListener)this.listeners.elementAt(i)).vetoableChange(propertyChangeEvent2);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException2) {
                    // empty catch block
                }
            }
            throw propertyVetoException;
        }
        Vector vector = (Vector)this.propertyListeners.get(propertyChangeEvent.getPropertyName());
        if (vector != null) {
            try {
                for (n = 0; n < vector.size(); ++n) {
                    ((VetoableChangeListener)vector.elementAt(n)).vetoableChange(propertyChangeEvent);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                int n2;
                PropertyChangeEvent propertyChangeEvent3 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue());
                for (n2 = 0; n2 < this.listeners.size(); ++n2) {
                    try {
                        ((VetoableChangeListener)this.listeners.elementAt(n)).vetoableChange(propertyChangeEvent);
                        continue;
                    }
                    catch (PropertyVetoException propertyVetoException3) {
                        // empty catch block
                    }
                }
                for (n2 = 0; n2 < n; ++n2) {
                    try {
                        ((VetoableChangeListener)vector.elementAt(n2)).vetoableChange(propertyChangeEvent3);
                        continue;
                    }
                    catch (PropertyVetoException propertyVetoException4) {
                        // empty catch block
                    }
                }
                throw propertyVetoException;
            }
        }
    }

    public void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    public void fireVetoableChange(String string, boolean bl, boolean bl2) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, string, new Boolean(bl), new Boolean(bl2)));
    }

    public void fireVetoableChange(String string, int n, int n2) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, string, new Integer(n), new Integer(n2)));
    }

    public boolean hasListeners(String string) {
        return this.listeners.size() > 0 || this.propertyListeners.get(string) != null;
    }
}

