/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    transient Hashtable propertyListeners;
    transient Vector listeners;
    Hashtable children;
    Object source;
    int propertyChangeSupportSerializedDataVersion;
    private static final long serialVersionUID = 6401253773779951803L;

    private /* synthetic */ void finit$() {
        this.propertyListeners = new Hashtable();
        this.listeners = new Vector();
        this.propertyChangeSupportSerializedDataVersion = 2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.children = this.propertyListeners.isEmpty() ? null : this.propertyListeners;
        objectOutputStream.defaultWriteObject();
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            if (!(propertyChangeListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(propertyChangeListener);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        PropertyChangeListener propertyChangeListener;
        objectInputStream.defaultReadObject();
        Hashtable hashtable = this.propertyListeners = this.children == null ? new Hashtable() : this.children;
        while ((propertyChangeListener = (PropertyChangeListener)objectInputStream.readObject()) != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public PropertyChangeSupport(Object object) {
        this.finit$();
        this.source = object;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addElement(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector vector = (Vector)this.propertyListeners.get(string);
                try {
                    vector.addElement(propertyChangeListener);
                }
                catch (NullPointerException nullPointerException) {
                    vector = new Vector();
                    vector.addElement(propertyChangeListener);
                    this.propertyListeners.put(string, vector);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removeElement(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector vector = (Vector)this.propertyListeners.get(string);
                try {
                    vector.removeElement(propertyChangeListener);
                    if (vector.size() == 0) {
                        this.propertyListeners.remove(string);
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((PropertyChangeListener)this.listeners.elementAt(i)).propertyChange(propertyChangeEvent);
        }
        Vector vector = (Vector)this.propertyListeners.get(propertyChangeEvent.getPropertyName());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ((PropertyChangeListener)vector.elementAt(i)).propertyChange(propertyChangeEvent);
            }
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, new Boolean(bl), new Boolean(bl2)));
    }

    public void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, new Integer(n), new Integer(n2)));
    }

    public boolean hasListeners(String string) {
        return this.listeners.size() > 0 || this.propertyListeners.get(string) != null;
    }
}

