/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.lang.ClassHelper;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class EventSetDescriptor
extends FeatureDescriptor {
    private Method addListenerMethod;
    private Method removeListenerMethod;
    private Class listenerType;
    private MethodDescriptor[] listenerMethodDescriptors;
    private Method[] listenerMethods;
    private boolean unicast;
    private boolean inDefaultEventSet;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.inDefaultEventSet = true;
    }

    public EventSetDescriptor(Class clazz, String string, Class clazz2, String string2) throws IntrospectionException {
        this.finit$();
        this.setName(string);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(clazz2)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        String[] stringArray = new String[]{string2};
        try {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            string = "";
        }
        this.findMethods(clazz, clazz2, stringArray, "add" + string + "Listener", "remove" + string + "Listener", string + "Event");
        this.listenerType = clazz2;
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public EventSetDescriptor(Class clazz, String string, Class clazz2, String[] stringArray, String string2, String string3) throws IntrospectionException {
        this.finit$();
        this.setName(string);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(clazz2)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        this.findMethods(clazz, clazz2, stringArray, string2, string3, null);
        this.listenerType = clazz2;
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public EventSetDescriptor(String string, Class clazz, Method[] methodArray, Method method, Method method2) throws IntrospectionException {
        this.finit$();
        this.setName(string);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(clazz)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        this.listenerMethods = methodArray;
        this.addListenerMethod = method;
        this.removeListenerMethod = method2;
        this.listenerType = clazz;
        this.checkMethods();
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public EventSetDescriptor(String string, Class clazz, MethodDescriptor[] methodDescriptorArray, Method method, Method method2) throws IntrospectionException {
        this.finit$();
        this.setName(string);
        if (!EventSetDescriptor.class$("java.util.EventListener").isAssignableFrom(clazz)) {
            throw new IntrospectionException("Listener type is not an EventListener.");
        }
        this.listenerMethodDescriptors = methodDescriptorArray;
        this.listenerMethods = new Method[methodDescriptorArray.length];
        for (int i = 0; i < this.listenerMethodDescriptors.length; ++i) {
            this.listenerMethods[i] = this.listenerMethodDescriptors[i].getMethod();
        }
        this.addListenerMethod = method;
        this.removeListenerMethod = method2;
        this.listenerType = clazz;
        this.checkMethods();
        this.checkAddListenerUnicast();
        if (this.removeListenerMethod.getExceptionTypes().length > 0) {
            throw new IntrospectionException("Listener remove method throws exceptions.");
        }
    }

    public Class getListenerType() {
        return this.listenerType;
    }

    public Method[] getListenerMethods() {
        return this.listenerMethods;
    }

    public MethodDescriptor[] getListenerMethodDescriptors() {
        if (this.listenerMethodDescriptors == null) {
            this.listenerMethodDescriptors = new MethodDescriptor[this.listenerMethods.length];
            for (int i = 0; i < this.listenerMethods.length; ++i) {
                this.listenerMethodDescriptors[i] = new MethodDescriptor(this.listenerMethods[i]);
            }
        }
        return this.listenerMethodDescriptors;
    }

    public Method getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public Method getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public void setUnicast(boolean bl) {
        this.unicast = bl;
    }

    public boolean isUnicast() {
        return this.unicast;
    }

    public void setInDefaultEventSet(boolean bl) {
        this.inDefaultEventSet = bl;
    }

    public boolean isInDefaultEventSet() {
        return this.inDefaultEventSet;
    }

    private void checkAddListenerUnicast() throws IntrospectionException {
        Class[] classArray = this.addListenerMethod.getExceptionTypes();
        if (classArray.length > 1) {
            throw new IntrospectionException("Listener add method throws too many exceptions.");
        }
        if (classArray.length == 1 && !EventSetDescriptor.class$("java.util.TooManyListenersException").isAssignableFrom(classArray[0])) {
            throw new IntrospectionException("Listener add method throws too many exceptions.");
        }
    }

    private void checkMethods() throws IntrospectionException {
        if (!this.addListenerMethod.getDeclaringClass().isAssignableFrom(this.removeListenerMethod.getDeclaringClass()) && !this.removeListenerMethod.getDeclaringClass().isAssignableFrom(this.addListenerMethod.getDeclaringClass())) {
            throw new IntrospectionException("add and remove listener methods do not come from the same class.  This is bad.");
        }
        if (!(this.addListenerMethod.getReturnType().equals(Void.TYPE) && this.addListenerMethod.getParameterTypes().length == 1 && this.listenerType.equals(this.addListenerMethod.getParameterTypes()[0]) && Modifier.isPublic(this.addListenerMethod.getModifiers()))) {
            throw new IntrospectionException("Add Listener Method invalid.");
        }
        if (!(this.removeListenerMethod.getReturnType().equals(Void.TYPE) && this.removeListenerMethod.getParameterTypes().length == 1 && this.listenerType.equals(this.removeListenerMethod.getParameterTypes()[0]) && this.removeListenerMethod.getExceptionTypes().length <= 0 && Modifier.isPublic(this.removeListenerMethod.getModifiers()))) {
            throw new IntrospectionException("Remove Listener Method invalid.");
        }
        for (int i = 0; i < this.listenerMethods.length; ++i) {
            if (!this.listenerMethods[i].getReturnType().equals(Void.TYPE) || Modifier.isPrivate(this.listenerMethods[i].getModifiers())) {
                throw new IntrospectionException("Event Method " + this.listenerMethods[i].getName() + " non-void or private.");
            }
            if (this.listenerMethods[i].getDeclaringClass().isAssignableFrom(this.listenerType)) continue;
            throw new IntrospectionException("Event Method " + this.listenerMethods[i].getName() + " not from class " + this.listenerType.getName());
        }
    }

    private void findMethods(Class clazz, Class clazz2, String[] stringArray, String string, String string2, String string3) throws IntrospectionException {
        int n;
        Method[] methodArray;
        Class[] classArray = new Class[]{clazz2};
        try {
            this.addListenerMethod = clazz.getMethod(string, classArray);
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException("SecurityException trying to access method " + string + ".");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException("Could not find method " + string + ".");
        }
        if (this.addListenerMethod == null || !this.addListenerMethod.getReturnType().equals(Void.TYPE)) {
            throw new IntrospectionException("Add listener method does not exist, is not public, or is not void.");
        }
        try {
            this.removeListenerMethod = clazz.getMethod(string2, classArray);
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException("SecurityException trying to access method " + string2 + ".");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException("Could not find method " + string2 + ".");
        }
        if (this.removeListenerMethod == null || !this.removeListenerMethod.getReturnType().equals(Void.TYPE)) {
            throw new IntrospectionException("Remove listener method does not exist, is not public, or is not void.");
        }
        try {
            methodArray = ClassHelper.getAllMethods(clazz2);
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException("Security: You cannot access fields in this class.");
        }
        Vector vector = new Vector();
        boolean[] blArray = new boolean[stringArray.length];
        for (n = 0; n < methodArray.length; ++n) {
            Method method;
            Class clazz3;
            if (Modifier.isPrivate(methodArray[n].getModifiers()) || !(clazz3 = (method = methodArray[n]).getReturnType()).equals(Void.TYPE)) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!method.getName().equals(stringArray[i]) || string3 != null && (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].getName().equals(string3) && !method.getParameterTypes()[0].getName().endsWith("." + string3))) continue;
                vector.addElement(method);
                blArray[i] = true;
            }
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            throw new IntrospectionException("Could not find event method " + stringArray[n]);
        }
        this.listenerMethods = new Method[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.listenerMethods[n] = (Method)vector.elementAt(n);
        }
    }
}

