/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public class WritableRaster
extends Raster {
    protected WritableRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), point);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, WritableRaster writableRaster) {
        super(sampleModel, dataBuffer, rectangle, point, writableRaster);
    }

    public WritableRaster getWritableParent() {
        return (WritableRaster)this.getParent();
    }

    public WritableRaster createWritableTranslatedChild(int n, int n2) {
        int n3 = this.sampleModelTranslateX - this.minX + n;
        int n4 = this.sampleModelTranslateY - this.minY + n2;
        return new WritableRaster(this.sampleModel, this.dataBuffer, new Rectangle(n, n2, this.width, this.height), new Point(n3, n4), this);
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        SampleModel sampleModel = nArray == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(nArray);
        return new WritableRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n5 - n, this.sampleModelTranslateY + n6 - n2), this);
    }

    public void setDataElements(int n, int n2, Object object) {
        this.sampleModel.setDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public void setDataElements(int n, int n2, Raster raster) {
        Object object = this.getDataElements(0, 0, raster.getWidth(), raster.getHeight(), null);
        this.setDataElements(n, n2, object);
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.sampleModel.setDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, object, this.dataBuffer);
    }

    public void setRect(Raster raster) {
        this.setRect(raster, 0, 0);
    }

    public void setRect(Raster raster, int n, int n2) {
        Rectangle rectangle = new Rectangle(raster.getMinX() + n, raster.getMinY() + n2, raster.getWidth(), raster.getHeight());
        Rectangle rectangle2 = this.getBounds().intersection(rectangle);
        if (rectangle2.isEmpty()) {
            return;
        }
        int n3 = rectangle2.x - n;
        int n4 = rectangle2.y - n2;
        int[] nArray = raster.getPixels(n3, n4, rectangle2.width, rectangle2.height, (int[])null);
        this.setPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray);
    }

    public void setPixel(int n, int n2, int[] nArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, float[] fArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, double[] dArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, nArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, fArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, dArray, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, int n4) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, float f) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, f, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, double d) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, d, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, nArray, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, fArray, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, dArray, this.dataBuffer);
    }
}

