/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class Raster {
    protected SampleModel sampleModel;
    protected DataBuffer dataBuffer;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;

    protected Raster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), point);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, Raster raster) {
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.sampleModelTranslateX = point.x;
        this.sampleModelTranslateY = point.y;
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
        this.parent = raster;
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, Point point) {
        int n5;
        int[] nArray = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = n5;
        }
        n5 = n4 * n2;
        return Raster.createInterleavedRaster(n, n2, n3, n5, n4, nArray, point);
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, int n5, int[] nArray, Point point) {
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(n, n2, n3, n5, n4, nArray);
        return Raster.createWritableRaster(componentSampleModel, point);
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, Point point) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int[] nArray, Point point) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(n, n2, n3, nArray);
        return Raster.createWritableRaster(singlePixelPackedSampleModel, point);
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, Point point) {
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(dataBuffer.getDataType(), n, n2, n3, n4, nArray);
        return Raster.createWritableRaster(componentSampleModel, dataBuffer, point);
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, int[] nArray2, Point point) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, Point point) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(dataBuffer.getDataType(), n, n2, n3, nArray);
        return Raster.createWritableRaster(singlePixelPackedSampleModel, dataBuffer, point);
    }

    public static Raster createRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return new Raster(sampleModel, dataBuffer, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        return new WritableRaster(sampleModel, point);
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return new WritableRaster(sampleModel, dataBuffer, point);
    }

    public Raster getParent() {
        return this.parent;
    }

    public final int getSampleModelTranslateX() {
        return this.sampleModelTranslateX;
    }

    public final int getSampleModelTranslateY() {
        return this.sampleModelTranslateY;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new WritableRaster(this.getSampleModel(), new Point(this.minX, this.minY));
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return this.createCompatibleWritableRaster(this.minX, this.minY, n, n2);
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rectangle) {
        return this.createCompatibleWritableRaster(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2, int n3, int n4) {
        SampleModel sampleModel = this.getSampleModel().createCompatibleSampleModel(n3, n4);
        return new WritableRaster(sampleModel, sampleModel.createDataBuffer(), new Point(n, n2));
    }

    public Raster createTranslatedChild(int n, int n2) {
        int n3 = this.sampleModelTranslateX - this.minX + n;
        int n4 = this.sampleModelTranslateY - this.minY + n2;
        return new Raster(this.sampleModel, this.dataBuffer, new Rectangle(n, n2, this.width, this.height), new Point(n3, n4), this);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        SampleModel sampleModel = nArray == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(nArray);
        return new Raster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n5 - n, this.sampleModelTranslateY + n6 - n2), this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumDataElements() {
        return this.numDataElements;
    }

    public final int getTransferType() {
        return this.sampleModel.getTransferType();
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public Object getDataElements(int n, int n2, Object object) {
        return this.sampleModel.getDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.sampleModel.getDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, object, this.dataBuffer);
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public float[] getPixel(int n, int n2, float[] fArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public double[] getPixel(int n, int n2, double[] dArray) {
        return this.sampleModel.getPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, nArray, this.dataBuffer);
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, fArray, this.dataBuffer);
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray) {
        return this.sampleModel.getPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, dArray, this.dataBuffer);
    }

    public int getSample(int n, int n2, int n3) {
        return this.sampleModel.getSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public float getSampleFloat(int n, int n2, int n3) {
        return this.sampleModel.getSampleFloat(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public double getSampleDouble(int n, int n2, int n3) {
        return this.sampleModel.getSampleDouble(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, this.dataBuffer);
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, nArray, this.dataBuffer);
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, fArray, this.dataBuffer);
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        return this.sampleModel.getSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, dArray, this.dataBuffer);
    }
}

