/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.gcj.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

public class IndexColorModel
extends ColorModel {
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private byte[] a;
    private int[] argb;
    private byte[] cmap;
    private int start;
    private int transparent;
    private int size;

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n, ColorModel.nArray(n, 3), ColorSpace.getInstance(1000), false, false, 1, Buffers.smallestAppropriateTransferType(n));
        this.r = byArray;
        this.g = byArray2;
        this.b = byArray3;
        this.size = n2;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, ColorModel.nArray(n, 4), ColorSpace.getInstance(1000), true, false, 2, Buffers.smallestAppropriateTransferType(n));
        this.r = byArray;
        this.g = byArray2;
        this.b = byArray3;
        this.transparent = n3;
        this.size = n2;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, ColorModel.nArray(n, 4), ColorSpace.getInstance(1000), true, false, 2, Buffers.smallestAppropriateTransferType(n));
        this.r = byArray;
        this.g = byArray2;
        this.b = byArray3;
        this.a = byArray4;
        this.size = n2;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        super(n, ColorModel.nArray(n, bl ? 4 : 3), ColorSpace.getInstance(1000), bl, false, bl ? 3 : 1, Buffers.smallestAppropriateTransferType(n));
        this.cmap = byArray;
        this.start = n3;
        this.size = n2;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4, int n5) {
        super(n, ColorModel.nArray(n, bl ? 4 : 3), ColorSpace.getInstance(1000), bl, false, bl ? 3 : (n4 < 0 ? 1 : 2), n5);
        this.cmap = byArray;
        this.start = n3;
        this.size = n2;
    }

    public final int getMapSize() {
        return this.size;
    }

    public final int getTransparentPixel() {
        return this.transparent;
    }

    public final void getReds(byte[] byArray) {
        if (this.r == null) {
            this.calcRGBArrays();
        }
        System.arraycopy(this.r, 0, byArray, 0, this.getMapSize());
    }

    public final void getGreens(byte[] byArray) {
        if (this.g == null) {
            this.calcRGBArrays();
        }
        System.arraycopy(this.g, 0, byArray, 0, this.getMapSize());
    }

    public final void getBlues(byte[] byArray) {
        if (this.b == null) {
            this.calcRGBArrays();
        }
        System.arraycopy(this.b, 0, byArray, 0, this.getMapSize());
    }

    public final void getAlphas(byte[] byArray) {
        if (this.a == null) {
            this.calcAlphaArray();
        }
        System.arraycopy(this.a, 0, byArray, 0, this.getMapSize());
    }

    public final void getRGBs(int[] nArray) {
        if (this.argb == null) {
            this.calcARGBArray();
        }
        System.arraycopy(this.argb, 0, nArray, 0, this.getMapSize());
    }

    public int getRed(int n) {
        try {
            return this.r[n];
        }
        catch (NullPointerException nullPointerException) {
            this.calcRGBArrays();
            return this.r[n];
        }
    }

    public int getGreen(int n) {
        try {
            return this.g[n];
        }
        catch (NullPointerException nullPointerException) {
            this.calcRGBArrays();
            return this.g[n];
        }
    }

    public int getBlue(int n) {
        try {
            return this.b[n];
        }
        catch (NullPointerException nullPointerException) {
            this.calcRGBArrays();
            return this.b[n];
        }
    }

    public int getAlpha(int n) {
        try {
            return this.a[n];
        }
        catch (NullPointerException nullPointerException) {
            this.calcAlphaArray();
            return this.a[n];
        }
    }

    private void calcRGBArrays() {
        int n = 0;
        boolean bl = this.hasAlpha();
        this.r = new byte[this.size];
        this.g = new byte[this.size];
        this.b = new byte[this.size];
        if (bl) {
            this.a = new byte[this.size];
        }
        for (int i = 0; i < this.size; ++i) {
            this.r[i] = this.cmap[n++];
            this.g[i] = this.cmap[n++];
            this.b[i] = this.cmap[n++];
            if (!this.hasAlpha()) continue;
            this.a[i] = this.cmap[n++];
        }
    }

    private void calcAlphaArray() {
        int n = this.getTransparency();
        switch (n) {
            case 1: 
            case 2: {
                this.a = ColorModel.nArray((byte)-1, this.size);
                if (n != 2) break;
                this.a[this.transparent] = 0;
                break;
            }
            case 3: {
                this.calcRGBArrays();
            }
        }
    }

    private void calcARGBArray() {
        int n = this.getMapSize();
        this.argb = new int[n];
        for (int i = 0; i < n; ++i) {
            this.argb[i] = this.getRGB(i);
        }
    }

    public int getRed(Object object) {
        return this.getRed(this.getPixelFromArray(object));
    }

    public int getGreen(Object object) {
        return this.getGreen(this.getPixelFromArray(object));
    }

    public int getBlue(Object object) {
        return this.getBlue(this.getPixelFromArray(object));
    }

    public int getAlpha(Object object) {
        return this.getAlpha(this.getPixelFromArray(object));
    }

    public int getRGB(Object object) {
        return this.getRGB(this.getPixelFromArray(object));
    }

    public Object getDataElements(int n, Object object) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n >>> 0 & 0xFF;
        int n6 = this.getPixelValue(n2, n3, n4, n5);
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, 1);
        dataBuffer.setElem(0, n6);
        return Buffers.getData(dataBuffer);
    }

    private int getPixelValue(int n, int n2, int n3, int n4) {
        if (this.r == null) {
            this.calcRGBArrays();
        }
        if (this.a == null) {
            this.calcAlphaArray();
        }
        int n5 = 256;
        int n6 = 196608;
        int n7 = -1;
        for (int i = 0; i < this.size; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12 = Math.abs(n - (this.a[i] & 0xFF));
            if (n12 > n5 || (n11 = (n10 = n2 - (this.r[i] & 0xFF)) * n10 + (n9 = n3 - (this.g[i] & 0xFF)) * n9 + (n8 = n4 - (this.b[i] & 0xFF)) * n8) >= n6) continue;
            n7 = i;
            n6 = n11;
        }
        return n7;
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        int n3 = this.getNumComponents();
        if (nArray == null) {
            nArray = new int[n2 + n3];
        }
        nArray[n2++] = this.r[n] & 0xFF;
        nArray[n2++] = this.g[n] & 0xFF;
        nArray[n2++] = this.b[n] & 0xFF;
        if (this.hasAlpha()) {
            nArray[n2++] = this.a[n] & 0xFF;
        }
        return nArray;
    }

    public final int[] getComponents(Object object, int[] nArray, int n) {
        return this.getComponents(this.getPixelFromArray(object), nArray, n);
    }

    public int getDataElement(int[] nArray, int n) {
        int n2 = nArray[n++];
        int n3 = nArray[n++];
        int n4 = nArray[n++];
        int n5 = this.hasAlpha() ? nArray[n++] : 255;
        return this.getPixelValue(n5, n2, n3, n4);
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        int n2 = this.getDataElement(nArray, n);
        DataBuffer dataBuffer = Buffers.createBuffer(this.transferType, object, 1);
        dataBuffer.setElem(0, n2);
        return Buffers.getData(dataBuffer);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[]{0};
        return new ComponentSampleModel(this.transferType, n, n2, 1, n, nArray);
    }
}

