/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.gcj.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;
    private boolean tightPixelPacking;

    private /* synthetic */ void finit$() {
        this.tightPixelPacking = false;
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this(n, n2, n3, n4, n5, new int[nArray.length], nArray);
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, nArray2.length);
        int n6;
        this.finit$();
        if (n4 < 0 || n5 < 0 || nArray2.length < 1 || nArray2.length != nArray.length) {
            throw new IllegalArgumentException();
        }
        this.bandOffsets = nArray2;
        this.bankIndices = nArray;
        for (n6 = 0; n6 < nArray.length; ++n6) {
            this.numBanks = Math.max(this.numBanks, nArray[n6] + 1);
        }
        this.scanlineStride = n5;
        this.pixelStride = n4;
        if (n4 == this.numBands) {
            this.tightPixelPacking = true;
            for (n6 = 0; n6 < this.numBands; ++n6) {
                if (nArray2[n6] == n6 && nArray[n6] == 0) continue;
                this.tightPixelPacking = false;
                break;
            }
        }
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new ComponentSampleModel(this.dataType, n, n2, this.pixelStride, this.scanlineStride, this.bankIndices, this.bandOffsets);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.bankIndices[nArray[i]];
            nArray3[i] = this.bandOffsets[nArray[i]];
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numBands; ++n) {
            n2 = Math.max(n2, this.bandOffsets[n]);
        }
        n = this.pixelStride * (this.width - 1) + this.scanlineStride * (this.height - 1) + n2 + 1;
        return Buffers.createBuffer(this.getDataType(), n, this.numBanks);
    }

    public int getOffset(int n, int n2) {
        return this.getOffset(n, n2, 0);
    }

    public int getOffset(int n, int n2, int n3) {
        return this.bandOffsets[n3] + this.pixelStride * n + this.scanlineStride * n2;
    }

    public final int[] getSampleSize() {
        int n = DataBuffer.getDataTypeSize(this.getDataType());
        int[] nArray = new int[this.numBands];
        Arrays.fill(nArray, n);
        return nArray;
    }

    public final int getSampleSize(int n) {
        return DataBuffer.getDataTypeSize(this.getDataType());
    }

    public final int[] getBankIndices() {
        return this.bankIndices;
    }

    public final int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.numBands;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        int[] nArray = new int[this.numBands];
        int[] nArray2 = dataBuffer.getOffsets();
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = this.bandOffsets[i] + nArray2[this.bankIndices[i]] + n3;
        }
        try {
            switch (this.getTransferType()) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    if (byArray == null) {
                        byArray = new byte[this.numBands];
                    }
                    for (int i = 0; i < this.numBands; ++i) {
                        int n4 = nArray[i];
                        byArray[i] = dataBufferByte.getData(this.bankIndices[i])[n4];
                    }
                    return byArray;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    if (sArray == null) {
                        sArray = new short[this.numBands];
                    }
                    for (int i = 0; i < this.numBands; ++i) {
                        int n5 = nArray[i];
                        sArray[i] = dataBufferUShort.getData(this.bankIndices[i])[n5];
                    }
                    return sArray;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray3 = (int[])object;
                    if (nArray3 == null) {
                        nArray3 = new int[this.numBands];
                    }
                    for (int i = 0; i < this.numBands; ++i) {
                        int n6 = nArray[i];
                        nArray3[i] = dataBufferInt.getData(this.bankIndices[i])[n6];
                    }
                    return nArray3;
                }
            }
            throw new IllegalStateException("unknown transfer type " + this.getTransferType());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "While reading data elements, x=" + n + ", y=" + n2 + ", " + ", xyOffset=" + n3 + ", data.getSize()=" + dataBuffer.getSize() + ": " + arrayIndexOutOfBoundsException;
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        if (!this.tightPixelPacking) {
            return super.getDataElements(n, n2, n3, n4, object, dataBuffer);
        }
        int n5 = n3 * this.numBands;
        int n6 = n5 * n4;
        DataBuffer dataBuffer2 = Buffers.createBuffer(this.getTransferType(), object, n6);
        object = Buffers.getData(dataBuffer2);
        int n7 = this.pixelStride * n + this.scanlineStride * n2 + dataBuffer.getOffset();
        if (this.scanlineStride == n5) {
            n5 *= n4;
            n4 = 1;
        }
        int n8 = 0;
        Object object2 = Buffers.getData(dataBuffer);
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(object2, n7, object, n8, n5);
            n7 += this.scanlineStride;
            n8 += n5;
        }
        return object;
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object, DataBuffer dataBuffer) {
        if (!this.tightPixelPacking) {
            super.setDataElements(n, n2, n3, n4, object, dataBuffer);
            return;
        }
        int n5 = n3 * this.numBands;
        int n6 = n5 * n4;
        DataBuffer dataBuffer2 = Buffers.createBufferFromData(this.getTransferType(), object, n6);
        int[] nArray = dataBuffer.getOffsets();
        int n7 = this.pixelStride * n + this.scanlineStride * n2 + nArray[0];
        if (this.scanlineStride == n5) {
            this.scanlineStride = n5 *= n4;
            n4 = 1;
        }
        int n8 = 0;
        Object object2 = Buffers.getData(dataBuffer);
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(object, n8, object2, n7, n5);
            n7 += this.scanlineStride;
            n8 += n5;
        }
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = dataBuffer.getElem(this.bankIndices[i], n3 + this.bandOffsets[i]);
        }
        return nArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.pixelStride * n + this.scanlineStride * n2;
        if (nArray == null) {
            nArray = new int[this.numBands * n3 * n4];
        }
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = n5;
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < this.numBands; ++i) {
                    nArray[n6++] = dataBuffer.getElem(this.bankIndices[i], n7 + this.bandOffsets[i]);
                }
                n7 += this.pixelStride;
            }
            n5 += this.scanlineStride;
        }
        return nArray;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return dataBuffer.getElem(this.bankIndices[n3], this.getOffset(n, n2, n3));
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        int[] nArray = new int[this.numBands];
        int[] nArray2 = dataBuffer.getOffsets();
        for (int i = 0; i < this.numBands; ++i) {
            nArray[i] = this.bandOffsets[i] + nArray2[this.bankIndices[i]] + n3;
        }
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                byte[] byArray = (byte[])object;
                for (int i = 0; i < this.numBands; ++i) {
                    dataBufferByte.getData((int)this.bankIndices[i])[nArray[i]] = byArray[i];
                }
                return;
            }
            case 1: {
                DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                short[] sArray = (short[])object;
                for (int i = 0; i < this.numBands; ++i) {
                    dataBufferUShort.getData((int)this.bankIndices[i])[nArray[i]] = sArray[i];
                }
                return;
            }
            case 3: {
                DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                int[] nArray3 = (int[])object;
                for (int i = 0; i < this.numBands; ++i) {
                    dataBufferInt.getData((int)this.bankIndices[i])[nArray[i]] = nArray3[i];
                }
                return;
            }
        }
        throw new UnsupportedOperationException("transfer type not implemented");
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = this.pixelStride * n + this.scanlineStride * n2;
        for (int i = 0; i < this.numBands; ++i) {
            dataBuffer.setElem(this.bankIndices[i], n3 + this.bandOffsets[i], nArray[i]);
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], this.getOffset(n, n2, n3), n4);
    }
}

