/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class RectangularShape
implements Shape,
Cloneable {
    protected RectangularShape() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public double getMinX() {
        return Math.min(this.getX(), this.getX() + this.getWidth());
    }

    public double getMinY() {
        return Math.min(this.getY(), this.getY() + this.getHeight());
    }

    public double getMaxX() {
        return Math.max(this.getX(), this.getX() + this.getWidth());
    }

    public double getMaxY() {
        return Math.max(this.getY(), this.getY() + this.getHeight());
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public Rectangle2D getFrame() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(double var1, double var3, double var5, double var7);

    public void setFrame(Point2D point2D, Dimension2D dimension2D) {
        this.setFrame(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setFrame(Rectangle2D rectangle2D) {
        this.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setFrameFromDiagonal(double d, double d2, double d3, double d4) {
        double d5;
        if (d > d3) {
            d5 = d3;
            d3 = d;
            d = d5;
        }
        if (d2 > d4) {
            d5 = d4;
            d4 = d2;
            d2 = d5;
        }
        this.setFrame(d, d2, d3 - d, d4 - d2);
    }

    public void setFrameFromDiagonal(Point2D point2D, Point2D point2D2) {
        this.setFrameFromDiagonal(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setFrameFromCenter(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d3 - d);
        double d6 = Math.abs(d4 - d2);
        this.setFrame(d - d5, d2 - d6, 2.0 * d5, 2.0 * d6);
    }

    public void setFrameFromCenter(Point2D point2D, Point2D point2D2) {
        this.setFrameFromCenter(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public boolean contains(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        return d >= d3 && d < d3 + d5 && d2 >= d4 && d2 < d4 + d6;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        double d = this.getX();
        double d2 = this.getWidth();
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getWidth();
        if (d < d3 || d >= d3 + d4 || d + d2 < d3 || d + d2 >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        double d7 = rectangle2D.getY();
        double d8 = rectangle2D.getHeight();
        return d5 >= d7 && d5 < d7 + d8 && d5 + d6 >= d7 && d5 + d6 < d7 + d8;
    }

    private boolean containsPoint(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getWidth();
        if (d < d3 || d >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        return d2 >= d5 && d2 < d5 + d6;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.containsPoint(rectangle2D.getMinX(), rectangle2D.getMinY()) && this.containsPoint(rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new AffineTransform.Iterator(affineTransform, new Iterator(this));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    class Iterator
    implements PathIterator {
        private /* synthetic */ RectangularShape this$0;
        private int coord = 0;
        private static final int START = 0;
        private static final int END_PLUS_ONE = 5;

        public Iterator(RectangularShape rectangularShape) {
            this.this$0 = rectangularShape;
        }

        public int currentSegment(double[] dArray) {
            int n;
            switch (this.coord) {
                case 0: {
                    dArray[0] = this.this$0.getX();
                    dArray[1] = this.this$0.getY();
                    n = 0;
                    break;
                }
                case 1: {
                    dArray[0] = this.this$0.getX() + this.this$0.getWidth();
                    dArray[1] = this.this$0.getY();
                    n = 1;
                    break;
                }
                case 2: {
                    dArray[0] = this.this$0.getX() + this.this$0.getWidth();
                    dArray[1] = this.this$0.getY() + this.this$0.getHeight();
                    n = 1;
                    break;
                }
                case 3: {
                    dArray[0] = this.this$0.getX();
                    dArray[1] = this.this$0.getY() + this.this$0.getHeight();
                    n = 1;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                default: {
                    n = 4;
                }
            }
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n;
            switch (this.coord) {
                case 0: {
                    fArray[0] = (float)this.this$0.getX();
                    fArray[1] = (float)this.this$0.getY();
                    n = 0;
                    break;
                }
                case 1: {
                    fArray[0] = (float)(this.this$0.getX() + this.this$0.getWidth());
                    fArray[1] = (float)this.this$0.getY();
                    n = 1;
                    break;
                }
                case 2: {
                    fArray[0] = (float)(this.this$0.getX() + this.this$0.getWidth());
                    fArray[1] = (float)(this.this$0.getY() + this.this$0.getHeight());
                    n = 1;
                    break;
                }
                case 3: {
                    fArray[0] = (float)this.this$0.getX();
                    fArray[1] = (float)(this.this$0.getY() + this.this$0.getHeight());
                    n = 1;
                    break;
                }
                default: {
                    n = 4;
                }
            }
            return n;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.coord == 5;
        }

        public void next() {
            if (this.coord < 5) {
                ++this.coord;
            }
        }
    }
}

