/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        int n = this.outcode(d, d2);
        int n2 = this.outcode(d3, d4);
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = this.getWidth();
        double d8 = this.getHeight();
        d -= d5;
        d3 -= d5;
        d2 -= d6;
        d4 -= d6;
        int n3 = n ^ n2;
        int n4 = n | n2;
        if ((n3 & 0xA) == 0) {
            if ((n4 & 0xA) != 0) {
                return false;
            }
            return (n & 5) != 0 || (n2 & 5) != 0;
        }
        if ((n3 & 5) == 0) {
            if ((n4 & 5) != 0) {
                return false;
            }
            return (n & 0xA) != 0 || (n2 & 0xA) != 0;
        }
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = -d / d9;
        double d12 = (d7 - d) / d9;
        if (d11 >= d12) {
            return false;
        }
        double d13 = -d2 / d10;
        double d14 = (d8 - d2) / d10;
        return !(d13 >= d14) && !(d13 >= d12) && !(d14 < d11);
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D point2D) {
        return this.outcode(point2D.getX(), point2D.getY());
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRect(d, d2, d3, d4);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getWidth();
        if (d < d3 || d >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        return d2 >= d5 && d2 < d5 + d6;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = this.getX();
        double d6 = this.getWidth();
        if (d < d5 || d >= d5 + d6 || d + d3 < d5 || d + d3 >= d5 + d6) {
            return false;
        }
        double d7 = this.getY();
        double d8 = this.getHeight();
        return d2 >= d7 && d2 < d7 + d8 && d2 + d4 >= d7 && d2 + d4 < d7 + d8;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2 + d4);
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d;
        double d2;
        double d3 = rectangle2D.getMinX();
        double d4 = rectangle2D2.getMinX();
        double d5 = Math.max(d3, d4);
        double d6 = rectangle2D.getMaxX();
        double d7 = Math.min(d6, d2 = rectangle2D2.getMaxX());
        if (d7 < d5) {
            d7 = d5;
        }
        double d8 = rectangle2D.getMinY();
        double d9 = rectangle2D2.getMinY();
        double d10 = Math.max(d8, d9);
        double d11 = rectangle2D.getMaxY();
        double d12 = Math.min(d11, d = rectangle2D2.getMaxY());
        if (d12 < d10) {
            d12 = d10;
        }
        rectangle2D3.setFrameFromDiagonal(d5, d10, d7, d12);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D2.getMinX();
        double d3 = Math.max(d, d2);
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D2.getMaxX();
        double d6 = Math.min(d4, d5);
        double d7 = rectangle2D.getMinY();
        double d8 = rectangle2D2.getMinY();
        double d9 = Math.max(d7, d8);
        double d10 = rectangle2D.getMaxY();
        double d11 = rectangle2D2.getMaxY();
        double d12 = Math.min(d10, d11);
        rectangle2D3.setFrameFromDiagonal(d3, d9, d6, d12);
    }

    public void add(double d, double d2) {
        double d3 = Math.min(this.getMinX(), d);
        double d4 = Math.max(this.getMaxX(), d);
        double d5 = Math.min(this.getMinY(), d2);
        double d6 = Math.max(this.getMaxY(), d2);
        this.setFrameFromDiagonal(d3, d5, d4, d6);
    }

    public void add(Point2D point2D) {
        this.add(point2D.getX(), point2D.getY());
    }

    public void add(Rectangle2D rectangle2D) {
        this.add(rectangle2D.getMinX(), rectangle2D.getMinY());
        this.add(rectangle2D.getMaxX(), rectangle2D.getMaxY());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.getPathIterator(affineTransform, 0.0);
    }

    public static class Float
    extends Rectangle2D {
        public float height;
        public float width;
        public float x;
        public float y;

        public Float() {
            this.y = 0.0f;
            this.x = 0.0f;
            this.width = 0.0f;
            this.height = 0.0f;
        }

        public Float(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (d < (double)this.x) {
                n |= 1;
            } else if (d >= (double)(this.x + this.width)) {
                n |= 4;
            }
            if (d2 < (double)this.y) {
                n |= 2;
            } else if (d2 >= (double)(this.y + this.height)) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Float float_ = new Float();
            Rectangle2D.intersect(this, rectangle2D, float_);
            return float_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Float float_ = new Float();
            Rectangle2D.union(this, rectangle2D, float_);
            return float_;
        }

        public String toString() {
            return "fixme";
        }
    }

    public static class Double
    extends Rectangle2D {
        public double height;
        public double width;
        public double x;
        public double y;

        public Double() {
            this.y = 0.0;
            this.x = 0.0;
            this.width = 0.0;
            this.height = 0.0;
        }

        public Double(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (d < this.x) {
                n |= 1;
            } else if (d >= this.x + this.width) {
                n |= 4;
            }
            if (d2 < this.y) {
                n |= 2;
            } else if (d2 >= this.y + this.height) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.intersect(this, rectangle2D, double_);
            return double_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.union(this, rectangle2D, double_);
            return double_;
        }

        public String toString() {
            return "fixme";
        }
    }
}

