/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

public abstract class Point2D
implements Cloneable {
    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    protected Point2D() {
    }

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public static double distanceSq(double d, double d2, double d3, double d4) {
        return (d3 -= d) * d3 + (d4 -= d2) * d4;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return Math.sqrt(Point2D.distance(d, d2, d3, d4));
    }

    public double distanceSq(double d, double d2) {
        return Point2D.distanceSq(this.getX(), d, this.getY(), d2);
    }

    public double distance(double d, double d2) {
        return Point2D.distance(this.getX(), d, this.getY(), d2);
    }

    public double distanceSq(Point2D point2D) {
        return Point2D.distanceSq(this.getX(), point2D.getX(), this.getY(), point2D.getY());
    }

    public double distance(Point2D point2D) {
        return Point2D.distance(this.getX(), point2D.getX(), this.getY(), point2D.getY());
    }

    public int hashCode() {
        return (int)this.getX() ^ (int)this.getY();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point2D)) {
            return false;
        }
        Point2D point2D = (Point2D)object;
        return this.getX() == point2D.getX() && this.getY() == point2D.getY();
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
            this.x = 0.0f;
            this.y = 0.0f;
        }

        public Float(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = (float)d;
            this.y = (float)d2;
        }

        public void setLocation(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

