/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;

public class AffineTransform
implements Cloneable,
Serializable {
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;
    private int type;

    public AffineTransform() {
        this.setToIdentity();
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.setTransform(affineTransform);
    }

    public AffineTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
        this.type = 0;
    }

    public AffineTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length >= 6) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
    }

    public AffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.type = 32;
    }

    public AffineTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m10 = dArray[1];
        this.m01 = dArray[2];
        this.m11 = dArray[3];
        if (dArray.length >= 6) {
            this.m02 = dArray[4];
            this.m12 = dArray[5];
        }
    }

    public static AffineTransform getTranslateInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, d2, d3);
        return affineTransform;
    }

    public static AffineTransform getScaleInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d, d2);
        return affineTransform;
    }

    public static AffineTransform getShearInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToShear(d, d2);
        return affineTransform;
    }

    public int getType() {
        return this.type;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public void getMatrix(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m10;
        dArray[2] = this.m01;
        dArray[3] = this.m11;
        if (dArray.length >= 6) {
            dArray[4] = this.m02;
            dArray[5] = this.m12;
        }
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double d, double d2) {
        this.m02 += d * this.m00 + d2 * this.m01;
        this.m12 += d * this.m10 + d2 * this.m11;
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.m00 * d2 + this.m01 * d3;
        double d5 = this.m00 * -d3 + this.m01 * d2;
        double d6 = this.m10 * d2 + this.m11 * d3;
        double d7 = this.m10 * -d3 + this.m11 * d2;
        this.m00 = d4;
        this.m01 = d5;
        this.m10 = d6;
        this.m11 = d7;
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void scale(double d, double d2) {
        this.m00 *= d;
        this.m01 *= d2;
        this.m10 *= d;
        this.m11 *= d2;
    }

    public void shear(double d, double d2) {
        double d3 = this.m00 + d * this.m01;
        double d4 = d * this.m00 + this.m01;
        double d5 = this.m10 * d2 + this.m11;
        double d6 = d * this.m10 + this.m11;
        this.m00 = d3;
        this.m01 = d4;
        this.m10 = d5;
        this.m11 = d6;
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.type = 0;
    }

    public void setToTranslation(double d, double d2) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m02 = d;
        this.m12 = d2;
        this.type = 1;
    }

    public void setToRotation(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = -d3;
        this.m02 = 0.0;
        this.m10 = d3;
        this.m11 = d2;
        this.m12 = 0.0;
        this.type = 16;
    }

    public void setToScale(double d, double d2) {
        this.m00 = d;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m11 = d2;
        this.type = d == d2 ? 2 : 4;
    }

    public void setToShear(double d, double d2) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m01 = d;
        this.m10 = d2;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.type = 0;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m01 = affineTransform.m01;
        this.m02 = affineTransform.m02;
        this.m10 = affineTransform.m10;
        this.m11 = affineTransform.m11;
        this.m12 = affineTransform.m12;
        this.type = affineTransform.type;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.type = 0;
    }

    public void concatenate(AffineTransform affineTransform) {
        double d = this.m00 * affineTransform.m00 + this.m01 * affineTransform.m10;
        double d2 = this.m00 * affineTransform.m01 + this.m01 * affineTransform.m11;
        double d3 = this.m00 * affineTransform.m02 + this.m01 * affineTransform.m12 + this.m02;
        double d4 = this.m10 * affineTransform.m00 + this.m11 * affineTransform.m10;
        double d5 = this.m10 * affineTransform.m01 + this.m11 * affineTransform.m11;
        double d6 = this.m10 * affineTransform.m02 + this.m11 * affineTransform.m12 + this.m12;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
    }

    public void preConcatenate(AffineTransform affineTransform) {
        double d = affineTransform.m00 * this.m00 + affineTransform.m01 * this.m10;
        double d2 = affineTransform.m00 * this.m01 + affineTransform.m01 * this.m11;
        double d3 = affineTransform.m00 * this.m02 + affineTransform.m01 * this.m12 + affineTransform.m02;
        double d4 = affineTransform.m10 * this.m00 + affineTransform.m11 * this.m10;
        double d5 = affineTransform.m10 * this.m01 + affineTransform.m11 * this.m11;
        double d6 = affineTransform.m10 * this.m02 + affineTransform.m11 * this.m12 + affineTransform.m12;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        double d = this.getDeterminant();
        if (d == 0.0) {
            throw new NoninvertibleTransformException("can't invert transform");
        }
        double d2 = this.m11 / d;
        double d3 = -this.m10 / d;
        double d4 = 0.0;
        double d5 = this.m01 / d;
        double d6 = -this.m00 / d;
        double d7 = 0.0;
        return new AffineTransform(d2, d3, d4, d5, d6, d7);
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.m00 * d + this.m01 * d2 + this.m02;
        double d4 = this.m10 * d + this.m11 * d2 + this.m12;
        point2D2.setLocation(d3, d4);
        return point2D2;
    }

    public void transform(Point2D[] point2DArray, int n, Point2D[] point2DArray2, int n2, int n3) {
        while (n3-- > 0) {
            point2DArray2[n2] = this.transform(point2DArray[n], point2DArray2[n2]);
            ++n;
            ++n2;
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        while (n3-- > 0) {
            float f = fArray[n];
            float f2 = fArray[n + 1];
            n += 2;
            float f3 = (float)(this.m00 * (double)f + this.m01 * (double)f2 + this.m02);
            float f4 = (float)(this.m10 * (double)f + this.m10 * (double)f2 + this.m12);
            fArray2[n2] = f3;
            fArray2[n2 + 1] = f4;
            n2 += 2;
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            n += 2;
            double d3 = this.m00 * d + this.m01 * d2 + this.m02;
            double d4 = this.m10 * d + this.m10 * d2 + this.m12;
            dArray2[n2] = d3;
            dArray2[n2 + 1] = d4;
            n2 += 2;
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (n3-- > 0) {
            float f = fArray[n];
            float f2 = fArray[n + 1];
            n += 2;
            double d = this.m00 * (double)f + this.m01 * (double)f2 + this.m02;
            double d2 = this.m10 * (double)f + this.m10 * (double)f2 + this.m12;
            dArray[n2] = d;
            dArray[n2 + 1] = d2;
            n2 += 2;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (n3-- > 0) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            n += 2;
            float f = (float)(this.m00 * d + this.m01 * d2 + this.m02);
            float f2 = (float)(this.m10 * d + this.m10 * d2 + this.m12);
            fArray[n2] = f;
            fArray[n2 + 1] = f2;
            n2 += 2;
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        double d = this.getDeterminant();
        if (d == 0.0) {
            throw new NoninvertibleTransformException("couldn't invert transform");
        }
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = (this.m11 * d2 + -this.m10 * d3) / d;
        double d5 = (this.m01 * d2 + -this.m00 * d3) / d;
        point2D2.setLocation(d4, d5);
        return point2D2;
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        double d = this.getDeterminant();
        if (d == 0.0) {
            throw new NoninvertibleTransformException("couldn't invert transform");
        }
        while (n3-- > 0) {
            double d2 = dArray[n];
            double d3 = dArray[n + 1];
            double d4 = (this.m11 * d2 + -this.m10 * d3) / d;
            double d5 = (this.m01 * d2 + -this.m00 * d3) / d;
            dArray2[n2] = d4;
            dArray2[n2 + 1] = d5;
            n2 += 2;
            n += 2;
        }
    }

    public Point2D deltaTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.m00 * d + this.m01 * d2;
        double d4 = this.m10 * d + this.m11 * d2;
        point2D2.setLocation(d3, d4);
        return point2D2;
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = this.m00 * d + this.m01 * d2;
            double d4 = this.m10 * d + this.m11 * d2;
            dArray2[n2] = d3;
            dArray2[n2 + 1] = d4;
            n2 += 2;
            n += 2;
        }
    }

    public Shape createTransformedShape(Shape shape) {
        return null;
    }

    public String toString() {
        return null;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public Object clone() {
        return new AffineTransform(this);
    }

    public int hashCode() {
        return 23;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)object;
        return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
    }

    class Iterator
    implements PathIterator {
        private /* synthetic */ AffineTransform this$0;
        private PathIterator subIterator;

        public Iterator(AffineTransform affineTransform, PathIterator pathIterator) {
            this.this$0 = affineTransform;
            this.subIterator = pathIterator;
        }

        public int currentSegment(double[] dArray) {
            int n = this.subIterator.currentSegment(dArray);
            int n2 = 0;
            switch (n) {
                case 3: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 0: 
                case 1: {
                    n2 = 1;
                    break;
                }
            }
            this.this$0.transform(dArray, 0, dArray, 0, n2);
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n = this.subIterator.currentSegment(fArray);
            int n2 = 0;
            switch (n) {
                case 3: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 0: 
                case 1: {
                    n2 = 1;
                    break;
                }
            }
            this.this$0.transform(fArray, 0, fArray, 0, n2);
            return n;
        }

        public int getWindingRule() {
            return this.subIterator.getWindingRule();
        }

        public boolean isDone() {
            return this.subIterator.isDone();
        }

        public void next() {
            this.subIterator.next();
        }
    }
}

