/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;

public class Window
extends Container {
    private String warningString;
    private int state;
    private int windowSerializedDataVersion;
    private transient WindowListener windowListener;
    private transient GraphicsConfiguration graphicsConfiguration;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.warningString = null;
        this.state = 0;
        this.windowSerializedDataVersion = 0;
    }

    Window() {
        this.finit$();
        this.setVisible(false);
        this.setLayout(new BorderLayout());
    }

    Window(GraphicsConfiguration graphicsConfiguration) {
        this();
        this.graphicsConfiguration = graphicsConfiguration;
    }

    public Window(Frame frame) {
        this((Window)frame);
    }

    public Window(Window window) {
        this();
        if (window == null) {
            throw new IllegalArgumentException("owner must not be null");
        }
        this.parent = window;
    }

    public Window(Window window, GraphicsConfiguration graphicsConfiguration) {
        this(window);
        this.graphicsConfiguration = graphicsConfiguration;
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        if (this.isVisible()) {
            this.toFront();
            return;
        }
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.validate();
        super.show();
    }

    public void hide() {
        super.hide();
    }

    public void dispose() {
        int n;
        this.hide();
        Window[] windowArray = this.getOwnedWindows();
        for (n = 0; n < windowArray.length; ++n) {
            windowArray[n].dispose();
        }
        for (n = 0; n < this.ncomponents; ++n) {
            this.component[n].removeNotify();
        }
        this.removeNotify();
    }

    public void toBack() {
        if (this.peer != null) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            windowPeer.toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            WindowPeer windowPeer = (WindowPeer)this.peer;
            windowPeer.toFront();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        boolean bl = true;
        if (!bl) {
            if (this.warningString != null) {
                return this.warningString;
            }
            String string = System.getProperty("awt.appletWarning");
            return string;
        }
        return null;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        return null;
    }

    public synchronized void addWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, windowListener);
    }

    public synchronized void removeWindowListener(WindowListener windowListener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, windowListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Window.class$("java.awt.event.WindowListener")) {
            return Component.getListenersImpl(clazz, this.windowListener);
        }
        return super.getListeners(clazz);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 206 && aWTEvent.id >= 200 && (this.windowListener != null || (this.eventMask & (long)64) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.windowListener != null) {
            switch (windowEvent.getID()) {
                case 205: {
                    this.windowListener.windowActivated(windowEvent);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(windowEvent);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(windowEvent);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(windowEvent);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(windowEvent);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(windowEvent);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(windowEvent);
                }
            }
        }
    }

    public Component getFocusOwner() {
        return null;
    }

    public boolean postEvent(Event event) {
        return false;
    }

    public boolean isShowing() {
        return this.isVisible();
    }

    public void applyResourceBundle(ResourceBundle resourceBundle) {
    }

    public void applyResourceBundle(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        if (resourceBundle != null) {
            this.applyResourceBundle(resourceBundle);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        if (this.peer != null) {
            return this.peer.getGraphicsConfiguration();
        }
        return null;
    }
}

