/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;

public class Scrollbar
extends Component
implements Adjustable {
    private AdjustmentListener listeners;
    private int orientation;
    private int value;
    private int visible;
    private int minimum;
    private int maximum;
    private int unit;
    private int block;

    public Scrollbar() {
        this(1, 0, 10, 0, 100);
    }

    public Scrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public Scrollbar(int n, int n2, int n3, int n4, int n5) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        if (n5 < n4) {
            n5 = n4;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (n2 > n5) {
            n2 = n5;
        }
        this.orientation = n;
        this.value = n2;
        this.visible = n3;
        this.minimum = n4;
        this.maximum = n5;
        this.unit = 1;
        this.block = 0;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this.orientation = n;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.setValues(n, this.visible, this.minimum, this.maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int n) {
        this.setValues(this.value, this.visible, n, this.maximum);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        this.setValues(this.value, this.visible, this.minimum, n);
    }

    public int getVisibleAmount() {
        return this.visible;
    }

    public int getVisible() {
        return this.visible;
    }

    public void setVisibleAmount(int n) {
        this.setValues(this.value, n, this.minimum, this.maximum);
    }

    public void setUnitIncrement(int n) {
        this.unit = n;
        if (this.peer != null) {
            ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
            scrollbarPeer.setLineIncrement(n);
        }
    }

    public void setLineIncrement(int n) {
        this.setUnitIncrement(n);
    }

    public int getUnitIncrement() {
        return this.unit;
    }

    public int getLineIncrement() {
        return this.unit;
    }

    public void setBlockIncrement(int n) {
        this.block = n;
        if (this.peer != null) {
            ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
            scrollbarPeer.setPageIncrement(n);
        }
    }

    public void setPageIncrement(int n) {
        this.setBlockIncrement(n);
    }

    public int getBlockIncrement() {
        return this.block;
    }

    public int getPageIncrement() {
        return this.block;
    }

    public synchronized void setValues(int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            n4 = n3;
        }
        if (n < n3) {
            n = n3;
        }
        if (n > n4) {
            n = n4;
        }
        this.value = n;
        this.visible = n2;
        this.minimum = n3;
        this.maximum = n4;
        if (this.peer != null) {
            ScrollbarPeer scrollbarPeer = (ScrollbarPeer)this.peer;
            scrollbarPeer.setValues(n, n2, n3, n4);
        }
    }

    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, adjustmentListener);
    }

    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, adjustmentListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.listeners != null) {
            this.listeners.adjustmentValueChanged(adjustmentEvent);
        }
    }

    protected String paramString() {
        return "Scrollbar[" + (this.orientation == 1 ? "VERTICAL" : "HORIZONTAL") + "," + this.value + "," + this.visible + "," + this.minimum + "," + this.maximum + "," + this.unit + "," + this.block + "]";
    }
}

