/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollPanePeer;

public class ScrollPane
extends Container {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    ScrollPaneAdjustable hscroll;
    ScrollPaneAdjustable vscroll;
    int policy;

    private /* synthetic */ void finit$() {
        this.hscroll = new ScrollPaneAdjustable(this, 0);
        this.vscroll = new ScrollPaneAdjustable(this, 1);
    }

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int n) {
        this.finit$();
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid value for policy");
        }
        this.policy = n;
        this.setSize(100, 100);
    }

    protected final void addImpl(Component component, Object object, int n) {
        if (n > 0) {
            throw new IllegalArgumentException("pos must be <= 0");
        }
        if (this.ncomponents > 0) {
            this.remove(this.component[0]);
        }
        if (component.isLightweight()) {
            Panel panel = new Panel();
            panel.add(component);
            component = panel;
        }
        super.addImpl(component, object, n);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollPane(this);
        }
        super.addNotify();
    }

    public void doLayout() {
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
        Dimension dimension = this.component[0].getPreferredSize();
        this.component[0].setSize(dimension.width, dimension.height);
        scrollPanePeer.childResized(dimension.width, dimension.height);
        this.setScrollPosition(this.hscroll.getValue(), this.vscroll.getValue());
    }

    public Adjustable getHAdjustable() {
        return this.hscroll;
    }

    public int getHScrollbarHeight() {
        if (this.peer == null) {
            return 0;
        }
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
        return scrollPanePeer.getHScrollbarHeight();
    }

    public int getScrollbarDisplayPolicy() {
        return this.policy;
    }

    public Point getScrollPosition() {
        return new Point(this.hscroll.getValue(), this.vscroll.getValue());
    }

    public Adjustable getVAdjustable() {
        return this.vscroll;
    }

    public Dimension getViewportSize() {
        Insets insets = this.getInsets();
        int n = this.width - insets.left - insets.right;
        int n2 = this.height - insets.top - insets.bottom;
        Dimension dimension = this.ncomponents > 0 ? this.component[0].getPreferredSize() : new Dimension(n, n2);
        dimension.setSize(n, n2);
        return dimension;
    }

    public int getVScrollbarWidth() {
        if (this.peer == null) {
            return 0;
        }
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
        return scrollPanePeer.getVScrollbarWidth();
    }

    public String paramString() {
        return "[" + this.getClass().getName() + ": " + (this.ncomponents > 0 ? this.component[0].paramString() : "") + "]";
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public void setScrollPosition(int n, int n2) {
        if (this.ncomponents == 0) {
            throw new NullPointerException("no child in ScrollPane");
        }
        Dimension dimension = this.component[0].getPreferredSize();
        Dimension dimension2 = this.getViewportSize();
        int n3 = Math.max(0, dimension.width - dimension2.width);
        int n4 = Math.max(0, dimension.height - dimension2.height);
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n4) {
            n2 = n4;
        }
        ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
        scrollPanePeer.setScrollPosition(n, n2);
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    class ScrollPaneAdjustable
    implements Adjustable {
        private /* synthetic */ ScrollPane this$0;
        AdjustmentListener listeners;
        int orient;
        int unit;
        int block;
        int value;

        public ScrollPaneAdjustable(ScrollPane scrollPane, int n) {
            this.this$0 = scrollPane;
            this.orient = n;
        }

        public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
            this.listeners = AWTEventMulticaster.add(this.listeners, adjustmentListener);
        }

        public int getBlockIncrement() {
            return this.block;
        }

        public int getMaximum() {
            Dimension dimension = ((Component)this.this$0).getPreferredSize();
            Dimension dimension2 = this.this$0.getViewportSize();
            int n = Math.max(0, dimension.width - dimension2.width);
            int n2 = Math.max(0, dimension.height - dimension2.height);
            if (this.orient == 0) {
                return n;
            }
            return n2;
        }

        public int getMinimum() {
            return 0;
        }

        public int getOrientation() {
            return this.orient;
        }

        public int getUnitIncrement() {
            return this.unit;
        }

        public int getValue() {
            return this.value;
        }

        public int getVisibleAmount() {
            Dimension dimension = this.this$0.getViewportSize();
            if (this.orient == 0) {
                return dimension.width;
            }
            return dimension.height;
        }

        public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
            this.listeners = AWTEventMulticaster.remove(this.listeners, adjustmentListener);
        }

        public void setBlockIncrement(int n) {
            throw new AWTError("can't use setBlockIncrement on this Adjustable");
        }

        public void setMaximum(int n) {
            throw new AWTError("can't use setMaximum on this Adjustable");
        }

        public void setMinimum(int n) {
            throw new AWTError("can't use setMinimum on this Adjustable");
        }

        public void setUnitIncrement(int n) {
            this.unit = n;
            if (this.this$0.peer != null) {
                ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.this$0.peer;
                scrollPanePeer.setUnitIncrement(this, n);
            }
        }

        public void setValue(int n) {
            this.value = n;
            if (this.this$0.peer != null) {
                ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.this$0.peer;
                scrollPanePeer.setValue(this, n);
            }
        }

        public void setVisibleAmount(int n) {
            throw new AWTError("can't use setVisibleAmount on this Adjustable");
        }
    }
}

