/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class Rectangle
extends Rectangle2D
implements Cloneable,
Shape {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public Rectangle(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public Rectangle(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public Rectangle(int n, int n2) {
        this.x = 0;
        this.y = 0;
        this.width = n;
        this.height = n2;
    }

    public Rectangle(Point point, Dimension dimension) {
        this.x = point.x;
        this.y = point.y;
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Rectangle(Point point) {
        this.x = point.x;
        this.y = point.y;
        this.width = 0;
        this.height = 0;
    }

    public Rectangle(Dimension dimension) {
        this.x = 0;
        this.y = 0;
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public Rectangle getBounds() {
        return (Rectangle)this.clone();
    }

    public void add(int n, int n2) {
        int n3 = this.x > n ? n : this.x;
        int n4 = this.y > n2 ? n2 : this.y;
        this.width = (this.x + this.width > n ? this.x + this.width : n) - n3;
        this.height = (this.y + this.height > n2 ? this.y + this.height : n2) - n4;
        this.x = n3;
        this.y = n4;
    }

    public void add(Point point) {
        this.add(point.x, point.y);
    }

    public void add(Rectangle rectangle) {
        int n = this.x > rectangle.x ? rectangle.x : this.x;
        int n2 = this.y > rectangle.y ? rectangle.y : this.y;
        this.width = (this.x + this.width > rectangle.x + rectangle.width ? this.x + this.width : rectangle.x + rectangle.width) - n;
        this.height = (this.y + this.height > rectangle.y + rectangle.height ? this.y + this.height : rectangle.y + rectangle.height) - n2;
        this.x = n;
        this.y = n2;
    }

    public boolean contains(int n, int n2) {
        return n >= this.x && n <= this.x + this.width && n2 >= this.y && n2 <= this.y + this.height;
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        return n >= this.x && n + n3 <= this.x + this.width && n2 >= this.y && n2 + n4 <= this.y + this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rectangle rectangle) {
        return this.contains(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean equals(Object object) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return rectangle.x == this.x && rectangle.y == this.y && rectangle.width == this.width && rectangle.height == this.height;
        }
        return false;
    }

    public double getHeight() {
        return this.height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return null;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void grow(int n, int n2) {
        this.width += n;
        this.height += n2;
    }

    public boolean inside(int n, int n2) {
        return this.contains(n, n2);
    }

    public Rectangle intersection(Rectangle rectangle) {
        int n = this.x < rectangle.x ? rectangle.x : this.x;
        int n2 = this.y < rectangle.y ? rectangle.y : this.y;
        int n3 = (this.x + this.width < rectangle.x + rectangle.width ? this.x + this.width : rectangle.x + rectangle.width) - n;
        int n4 = (this.y + this.height < rectangle.y + rectangle.height ? this.y + this.height : rectangle.y + rectangle.height) - n2;
        if (n3 >= 0 && n4 >= 0) {
            return new Rectangle(n, n2, n3, n4);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean intersects(Rectangle rectangle) {
        int n = (this.x + this.width < rectangle.x + rectangle.width ? this.x + this.width : rectangle.x + rectangle.width) - (this.x < rectangle.x ? rectangle.x : this.x);
        int n2 = (this.y + this.height < rectangle.y + rectangle.height ? this.y + this.height : rectangle.y + rectangle.height) - (this.y < rectangle.y ? rectangle.y : this.y);
        return n > 0 && n2 > 0;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public void move(int n, int n2) {
        this.setLocation(n, n2);
    }

    public int outcode(double d, double d2) {
        return 0;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void resize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void setBounds(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public void setRect(double d, double d2, double d3, double d4) {
        this.x = (int)d;
        this.y = (int)d2;
        this.width = (int)d3;
        this.height = (int)d4;
    }

    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void translate(int n, int n2) {
        n += n;
        n2 += n2;
    }

    public Rectangle union(Rectangle rectangle) {
        int n = this.x > rectangle.x ? rectangle.x : this.x;
        int n2 = this.y > rectangle.y ? rectangle.y : this.y;
        int n3 = (this.x + this.width > rectangle.x + rectangle.width ? this.x + this.width : rectangle.x + rectangle.width) - n;
        int n4 = (this.y + this.height > rectangle.y + rectangle.height ? this.y + this.height : rectangle.y + rectangle.height) - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.intersect(this, rectangle2D, double_);
        return double_;
    }

    public Rectangle2D createUnion(Rectangle2D rectangle2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Rectangle2D.union(this, rectangle2D, double_);
        return double_;
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

