/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.MenuItemPeer;
import java.util.EventListener;

public class MenuItem
extends MenuComponent {
    boolean enabled;
    String label;
    String actionCommand;
    long eventMask;
    MenuShortcut shortcut;
    int menuItemSerializedDataVersion;
    transient ActionListener actionListener;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MenuItem() {
        this.label = "";
    }

    public MenuItem(String string) {
        this.label = string;
    }

    public MenuItem(String string, MenuShortcut menuShortcut) {
        this.label = string;
        this.shortcut = menuShortcut;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        if (this.peer != null) {
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            menuItemPeer.setLabel(string);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            if (this.peer != null) {
                MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
                menuItemPeer.setEnabled(bl);
            }
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
    }

    public void deleteShortcut() {
        this.setShortcut(null);
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ (long)-1;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        if (this.actionListener != null) {
            this.enableEvents(128);
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == MenuItem.class$("java.awt.event.ActionListener")) {
            return Component.getListenersImpl(clazz, this.actionListener);
        }
        return Component.getListenersImpl(clazz, null);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 1001 && aWTEvent.id >= 1001 && (this.actionListener != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(aWTEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public String paramString() {
        return this.name + ",label=" + this.label;
    }
}

