/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.peer.MenuBarPeer;
import java.util.Enumeration;
import java.util.Vector;

public class MenuBar
extends MenuComponent
implements MenuContainer {
    Vector menus = new Vector();
    Menu help_menu;

    public synchronized Menu add(Menu menu) {
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        this.menus.add(menu);
        if (this.peer != null) {
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            menuBarPeer.add(menu);
        }
        return menu;
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
        }
    }

    public int countMenus() {
        return this.getMenuCount();
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        MenuItem menuItem;
        while ((menuItem = this.getShortcutMenuItem(menuShortcut)) != null) {
            menuItem.deleteShortcut();
        }
    }

    public Menu getHelpMenu() {
        return this.help_menu;
    }

    public Menu getMenu(int n) {
        return (Menu)this.menus.get(n);
    }

    public int getMenuCount() {
        return this.menus.size();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        MenuEnumeration menuEnumeration = new MenuEnumeration(this);
        while (menuEnumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)menuEnumeration.nextElement();
            if (menuItem.getShortcut() != menuShortcut) continue;
            return menuItem;
        }
        return null;
    }

    public synchronized void remove(MenuComponent menuComponent) {
        int n = this.menus.size();
        for (int i = 0; i < n; ++i) {
            if (this.menus.get(i) != menuComponent) continue;
            this.remove(i);
            break;
        }
    }

    public synchronized void remove(int n) {
        Menu menu = (Menu)this.menus.get(n);
        this.menus.remove(n);
        menu.removeNotify();
        menu.parent = null;
        if (this.peer != null) {
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            menuBarPeer.remove(n);
        }
    }

    public synchronized void setHelpMenu(Menu menu) {
        if (this.help_menu != null) {
            this.help_menu.removeNotify();
            this.help_menu.parent = null;
        }
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        if (menu.parent != null) {
            menu.parent.remove(menu);
        }
        menu.parent = this;
        if (this.peer != null) {
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            menuBarPeer.addHelpMenu(menu);
        }
    }

    public synchronized Enumeration shortcuts() {
        return new ShortcutEnumeration(new MenuEnumeration(this));
    }

    static class ShortcutEnumeration
    implements Enumeration {
        Enumeration back;

        ShortcutEnumeration(Enumeration enumeration) {
            this.back = enumeration;
        }

        public boolean hasMoreElements() {
            return this.back.hasMoreElements();
        }

        public Object nextElement() {
            MenuItem menuItem;
            while ((menuItem = (MenuItem)this.back.nextElement()).getShortcut() == null) {
            }
            return menuItem.getShortcut();
        }
    }

    static class MenuEnumeration
    implements Enumeration {
        Enumeration main;
        Enumeration sub = null;
        MenuBar menubar;

        MenuEnumeration(Menu menu) {
            this.menubar = null;
            this.main = menu.items.elements();
        }

        MenuEnumeration(MenuBar menuBar) {
            this.menubar = menuBar;
            this.main = menuBar.menus.elements();
        }

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.sub != null) {
                bl = this.sub.hasMoreElements();
            }
            if (!bl) {
                bl = this.main.hasMoreElements();
            }
            if (!bl && this.menubar != null) {
                if (this.menubar.help_menu != null) {
                    this.main = new MenuEnumeration(this.menubar.help_menu);
                    bl = this.main.hasMoreElements();
                }
                this.menubar = null;
            }
            return bl;
        }

        public Object nextElement() {
            Object object;
            while (true) {
                if (this.sub.hasMoreElements()) {
                    return this.sub.nextElement();
                }
                this.sub = null;
                if (!this.main.hasMoreElements() && this.menubar != null && this.menubar.help_menu != null) {
                    this.main = new MenuEnumeration(this.menubar.help_menu);
                    this.menubar = null;
                }
                if (!((object = this.main.nextElement()) instanceof Menu)) break;
                this.sub = new MenuEnumeration((Menu)object);
            }
            return object;
        }
    }
}

