/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    private int hgap;
    private int vgap;
    private int rows;
    private int cols;

    public void addLayoutComponent(String string, Component component) {
    }

    public int getColumns() {
        return this.cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("number of rows cannot be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("number of columns cannot be negative");
        }
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("both rows and columns cannot be 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        Component[] componentArray = container.component;
        int n2 = this.rows;
        int n3 = this.cols;
        if (n2 == 0) {
            n2 = (n + n3 - 1) / n3;
        } else {
            n3 = (n + n2 - 1) / n2;
        }
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n4 = dimension.width - insets.left - insets.right;
        int n5 = dimension.height - insets.top - insets.bottom;
        int n6 = (n4 - (n2 - 1) * this.hgap) / n2;
        int n7 = (n5 - (n3 - 1) * this.vgap) / n3;
        int n8 = insets.left;
        int n9 = insets.top;
        int n10 = 0;
        int n11 = 0;
        while (n10 < n) {
            componentArray[n10].setBounds(n8, n9, n4, n5);
            ++n10;
            if (++n11 == n3) {
                n11 = 0;
                n9 += this.vgap + n5;
                n8 = insets.left;
                continue;
            }
            n8 += this.hgap + n4;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, false);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setColumns(int n) {
        if (this.cols < 0) {
            throw new IllegalArgumentException("number of columns cannot be negative");
        }
        if (n == 0 && this.rows == 0) {
            throw new IllegalArgumentException("number of rows is already 0");
        }
        this.cols = n;
    }

    public void setHgap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        this.hgap = n;
    }

    public void setRows(int n) {
        if (this.rows < 0) {
            throw new IllegalArgumentException("number of rows cannot be negative");
        }
        if (n == 0 && this.cols == 0) {
            throw new IllegalArgumentException("number of columns is already 0");
        }
        this.rows = n;
    }

    public void setVgap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.vgap = n;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }

    private Dimension getSize(Container container, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = container.getComponentCount();
        Component[] componentArray = container.component;
        for (n = 0; n < n4; ++n) {
            Dimension dimension = bl ? componentArray[n].getMinimumSize() : componentArray[n].getPreferredSize();
            n2 = Math.max(dimension.width, n2);
            n3 = Math.max(dimension.height, n3);
        }
        n = this.rows;
        int n5 = this.cols;
        if (n == 0) {
            n = (n4 + n5 - 1) / n5;
        } else {
            n5 = (n4 + n - 1) / n;
        }
        return new Dimension(n * (n2 + this.hgap) - this.hgap, n5 * (n3 + this.vgap) - this.vgap);
    }
}

