/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.io.Serializable;

public class FontMetrics
implements Serializable {
    protected Font font;

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return this.getMaxAscent() + this.getMaxDescent() - (this.getAscent() + this.getDescent());
    }

    public int getAscent() {
        return this.getHeight() - (this.getDescent() + this.getLeading());
    }

    public int getDescent() {
        return this.getHeight() - (this.getLeading() + this.getDescent());
    }

    public int getHeight() {
        return this.getLeading() + this.getAscent() + this.getDescent();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int n) {
        return this.charWidth((char)n);
    }

    public int charWidth(char c) {
        Character c2 = new Character(c);
        return this.stringWidth(c2.toString());
    }

    public int stringWidth(String string) {
        return this.charsWidth(string.toCharArray(), 0, string.length());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.stringWidth(new String(cArray, n, n2));
    }

    public int bytesWidth(byte[] byArray, int n, int n2) {
        return this.stringWidth(new String(byArray, n, n2));
    }

    public int[] getWidths() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            nArray[i] = this.charWidth((char)i);
        }
        return nArray;
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    public String toString() {
        return this.getClass() + "[font=" + this.font + ",ascent=" + this.getAscent() + ",descent=" + this.getDescent() + ",height=" + this.getHeight() + "]";
    }
}

