/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private int align;
    private int hgap;
    private int vgap;

    public void addLayoutComponent(String string, Component component) {
    }

    public int getAlignment() {
        return this.align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public FlowLayout() {
        this(1, 0, 0);
    }

    public FlowLayout(int n) {
        this(n, 0, 0);
    }

    public FlowLayout(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4) {
            throw new IllegalArgumentException("invalid align: " + n);
        }
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        Component[] componentArray = container.component;
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        boolean bl = componentOrientation.isLeftToRight();
        int n2 = insets.top + this.vgap;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = insets.left + this.hgap + insets.right;
            int n7 = 0;
            for (n5 = n3; n5 < n; ++n5) {
                Dimension dimension2 = componentArray[n3].getPreferredSize();
                n4 = n6 + this.hgap + dimension2.width;
                if (n4 > dimension.width) break;
                n6 = n4;
                n7 = Math.max(n7, dimension2.height);
            }
            if (n5 == n3) {
                ++n5;
            }
            int n8 = this.align;
            if (this.align == 3) {
                n8 = bl ? 0 : 2;
            } else if (this.align == 4) {
                int n9 = n8 = bl ? 2 : 0;
            }
            n4 = n8 == 0 ? insets.left + this.hgap : (n8 == 1 ? (dimension.width - n6) / 2 : dimension.width - n6);
            int n10 = n3;
            while (n3 < n5) {
                Dimension dimension3 = componentArray[n3].getPreferredSize();
                componentArray[n3].setLocation(n4, n2);
                n4 += dimension3.width + this.vgap;
                ++n10;
            }
            n3 = n5;
            n2 += n7 + this.vgap;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, false);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setAlignment(int n) {
        if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4) {
            throw new IllegalArgumentException("invalid align: " + n);
        }
        this.align = n;
    }

    public void setHgap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        this.hgap = n;
    }

    public void setVgap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.vgap = n;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",align=" + this.align + "]";
    }

    private Dimension getSize(Container container, boolean bl) {
        int n = container.getComponentCount();
        Component[] componentArray = container.component;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Dimension dimension = bl ? componentArray[i].getMinimumSize() : componentArray[i].getPreferredSize();
            n2 += dimension.width;
            n3 = Math.max(dimension.height, n3);
        }
        Insets insets = container.getInsets();
        return new Dimension(n2 += (n + 1) * this.hgap + insets.left + insets.right, n3 += 2 * this.vgap + insets.top + insets.bottom);
    }
}

