/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

public class EventQueue {
    private static final int INITIAL_QUEUE_DEPTH = 8;
    private AWTEvent[] queue;
    private int next_in;
    private int next_out;
    private EventQueue next;
    private EventQueue prev;
    private EventDispatchThread dispatchThread;

    private /* synthetic */ void finit$() {
        this.queue = new AWTEvent[8];
        this.next_in = 0;
        this.next_out = 0;
        this.dispatchThread = new EventDispatchThread(this);
    }

    public EventQueue() {
        this.finit$();
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next != null) {
            return this.next.getNextEvent();
        }
        while (this.next_in == this.next_out) {
            this.wait();
        }
        AWTEvent aWTEvent = this.queue[this.next_out];
        if (++this.next_out == this.queue.length) {
            this.next_out = 0;
        }
        return aWTEvent;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        if (this.next_in != this.next_out) {
            return this.queue[this.next_out];
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        if (this.next != null) {
            return this.next.peekEvent(n);
        }
        int n2 = this.next_out;
        while (n2 != this.next_in) {
            AWTEvent aWTEvent = this.queue[n2];
            if (aWTEvent.id != n) continue;
            return aWTEvent;
        }
        return null;
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        AWTEvent[] aWTEventArray;
        if (this.next != null) {
            this.next.postEvent(aWTEvent);
            return;
        }
        int n = this.next_out;
        while (n != this.next_in) {
            Object object;
            aWTEventArray = this.queue[n];
            if (aWTEventArray.id == aWTEvent.id && (object = aWTEventArray.getSource()) == aWTEvent.getSource() && object instanceof Component) {
                Component component = (Component)object;
                AWTEvent aWTEvent2 = component.coalesceEvents((AWTEvent)aWTEventArray, aWTEvent);
                if (aWTEvent2 == null) break;
                this.queue[n] = aWTEvent2;
                return;
            }
            if (++n != this.queue.length) continue;
            n = 0;
        }
        this.queue[this.next_in] = aWTEvent;
        if (++this.next_in == this.queue.length) {
            this.next_in = 0;
        }
        if (this.next_in == this.next_out) {
            aWTEventArray = this.queue;
            this.queue = new AWTEvent[this.queue.length * 2];
            int n2 = aWTEventArray.length - this.next_out;
            System.arraycopy(aWTEventArray, this.next_out, this.queue, 0, n2);
            if (this.next_out != 0) {
                System.arraycopy(aWTEventArray, 0, this.queue, n2, this.next_out);
            }
            this.next_out = 0;
            this.next_in = aWTEventArray.length;
        }
        this.notify();
    }

    public static void invokeAndWait(Runnable runnable) throws InvocationTargetException, InterruptedException {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread thread = Thread.currentThread();
        if (thread == eventQueue.dispatchThread) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, thread, true);
        Object object = thread;
        synchronized (object) {
            try {
                eventQueue.postEvent(invocationEvent);
                thread.wait();
            }
            finally {
                Object var6_5 = null;
            }
            object = invocationEvent.getException();
            if (object != null) {
                throw new InvocationTargetException((Throwable)object);
            }
            return;
        }
    }

    static void invokeLater(Runnable runnable) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, null, false);
        eventQueue.postEvent(invocationEvent);
    }

    static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    public synchronized void push(EventQueue eventQueue) {
        int n = this.next_out;
        while (n != this.next_in) {
            eventQueue.postEvent(this.queue[n]);
            this.next_out = n++;
            if (n != this.queue.length) continue;
            n = 0;
        }
        this.next = eventQueue;
        eventQueue.prev = this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void pop() {
        if (this.prev == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue = this.prev;
        synchronized (eventQueue) {
            Object var3_2;
            try {
                this.prev.next = null;
            }
            finally {
                var3_2 = null;
            }
            eventQueue = this;
            synchronized (eventQueue) {
                try {
                    int n = this.next_out;
                    while (n != this.next_in) {
                        this.prev.postEvent(this.queue[n]);
                        this.next_out = n++;
                        if (n != this.queue.length) continue;
                        n = 0;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    throw throwable;
                }
            }
        }
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActiveEvent) {
            ActiveEvent activeEvent = (ActiveEvent)((Object)aWTEvent);
            activeEvent.dispatch();
        } else {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                component.dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                MenuComponent menuComponent = (MenuComponent)object;
                menuComponent.dispatchEvent(aWTEvent);
            }
        }
    }
}

