/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EventListener;

public class Container
extends Component {
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    Dimension maxSize;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getComponentCount() {
        return this.ncomponents;
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public Component getComponent(int n) {
        if (n < 0 || n >= this.ncomponents) {
            throw new ArrayIndexOutOfBoundsException("no such component");
        }
        return this.component[n];
    }

    public Component[] getComponents() {
        Component[] componentArray = new Component[this.ncomponents];
        if (this.ncomponents > 0) {
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
        }
        return componentArray;
    }

    public Insets getInsets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Insets insets() {
        return this.getInsets();
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (n > this.ncomponents || component instanceof Window || component instanceof Container && ((Container)component).isAncestorOf(this)) {
            throw new IllegalArgumentException();
        }
        if (component.parent != null) {
            component.parent.remove(component);
        }
        component.parent = this;
        if (this.peer != null) {
            component.addNotify();
            if (component.isLightweight()) {
                this.enableEvents(component.eventMask);
            }
        }
        this.invalidate();
        if (this.component == null) {
            this.component = new Component[4];
        }
        if (this.ncomponents >= this.component.length) {
            int n2 = this.component.length * 2;
            Component[] componentArray = new Component[n2];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            this.component = componentArray;
        }
        if (n == -1) {
            this.component[this.ncomponents++] = component;
        } else {
            System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
            this.component[n] = component;
            ++this.ncomponents;
        }
        if (this.layoutMgr != null) {
            if (object != null && this.layoutMgr instanceof LayoutManager2) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                layoutManager2.addLayoutComponent(component, object);
            } else {
                this.layoutMgr.addLayoutComponent((String)object, component);
            }
        }
        ContainerEvent containerEvent = new ContainerEvent(this, 300, component);
        this.dispatchEvent(containerEvent);
    }

    public void remove(int n) {
        Component component = this.component[n];
        component.removeNotify();
        System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
        this.component[this.ncomponents += -1] = null;
        this.invalidate();
        if (this.layoutMgr != null) {
            this.layoutMgr.removeLayoutComponent(component);
        }
        ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
        this.dispatchEvent(containerEvent);
    }

    public void remove(Component component) {
        for (int i = 0; i < this.ncomponents; ++i) {
            if (this.component[i] != component) continue;
            this.remove(i);
            break;
        }
    }

    public void removeAll() {
        while (this.ncomponents > 0) {
            this.remove(0);
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        this.invalidate();
    }

    public void doLayout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void layout() {
        this.doLayout();
    }

    public void invalidate() {
        super.invalidate();
    }

    public void validate() {
        if (!this.isValid()) {
            this.validateTree();
        }
    }

    protected void validateTree() {
        if (this.valid) {
            return;
        }
        ContainerPeer containerPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            containerPeer = (ContainerPeer)this.peer;
            containerPeer.beginValidate();
        }
        this.doLayout();
        for (int i = 0; i < this.ncomponents; ++i) {
            Component component = this.component[i];
            if (component instanceof Container) {
                ((Container)component).validateTree();
                continue;
            }
            this.component[i].validate();
        }
        this.valid = true;
        if (containerPeer != null) {
            containerPeer.endValidate();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
    }

    public Dimension getPreferredSize() {
        if (this.layoutMgr != null) {
            return this.layoutMgr.preferredLayoutSize(this);
        }
        return super.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.layoutMgr != null) {
            return this.layoutMgr.minimumLayoutSize(this);
        }
        return super.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            return layoutManager2.maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    public float getAlignmentX() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            return layoutManager2.getLayoutAlignmentX(this);
        }
        return 0.5f;
    }

    public float getAlignmentY() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            return layoutManager2.getLayoutAlignmentY(this);
        }
        return 0.5f;
    }

    public void paint(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        super.paint(graphics);
        this.visitChildren(graphics, GfxPaintVisitor.INSTANCE, true);
    }

    private void visitChildren(Graphics graphics, GfxVisitor gfxVisitor, boolean bl) {
        for (int i = 0; i < this.ncomponents; ++i) {
            boolean bl2;
            Component component = this.component[i];
            boolean bl3 = bl2 = component.isVisible() && (component.isLightweight() || !bl);
            if (!bl2) continue;
            this.visitChild(graphics, gfxVisitor, component);
        }
    }

    private void visitChild(Graphics graphics, GfxVisitor gfxVisitor, Component component) {
        Rectangle rectangle = component.getBounds();
        Rectangle rectangle2 = graphics.getClipBounds().intersection(rectangle);
        if (rectangle2.isEmpty()) {
            return;
        }
        Graphics graphics2 = graphics.create();
        graphics2.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics2.translate(rectangle.x, rectangle.y);
        gfxVisitor.visit(component, graphics2);
    }

    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        this.visitChildren(graphics, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics graphics) {
        super.paint(graphics);
        this.visitChildren(graphics, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics graphics) {
        super.paint(graphics);
        this.visitChildren(graphics, GfxPrintAllVisitor.INSTANCE, true);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 301 && aWTEvent.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    public void addContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
    }

    public void removeContainerListener(ContainerListener containerListener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Container.class$("java.awt.event.ContainerListener")) {
            return Component.getListenersImpl(clazz, this.containerListener);
        }
        return super.getListeners(clazz);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener == null) {
            return;
        }
        switch (containerEvent.id) {
            case 300: {
                this.containerListener.componentAdded(containerEvent);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(containerEvent);
            }
        }
    }

    public void deliverEvent(Event event) {
    }

    public Component getComponentAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            int n3;
            int n4;
            if (!this.component[i].isVisible() || !this.component[i].contains(n4 = n - this.component[i].x, n3 = n2 - this.component[i].y)) continue;
            return this.component[i];
        }
        return this;
    }

    public Component locate(int n, int n2) {
        return this.getComponentAt(n, n2);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public Component findComponentAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        for (int i = 0; i < this.ncomponents; ++i) {
            if (!this.component[i].isVisible()) continue;
            int n3 = n - this.component[i].x;
            int n4 = n2 - this.component[i].y;
            if (this.component[i] instanceof Container) {
                Container container = (Container)this.component[i];
                Component component = container.findComponentAt(n3, n4);
                if (component == null) continue;
                return component;
            }
            if (!this.component[i].contains(n3, n4)) continue;
            return this.component[i];
        }
        return this;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public void addNotify() {
        super.addNotify();
    }

    void addNotifyContainerChildren() {
        int n = this.ncomponents;
        while (--n >= 0) {
            this.component[n].addNotify();
            if (!this.component[n].isLightweight()) continue;
            this.enableEvents(this.component[n].eventMask);
        }
    }

    public void removeNotify() {
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].removeNotify();
        }
        super.removeNotify();
    }

    public boolean isAncestorOf(Component component) {
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.layoutMgr != null) {
            string = string + "," + this.layoutMgr.getClass().getName();
        }
        return string;
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].list(printStream, n + 2);
        }
    }

    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        for (int i = 0; i < this.ncomponents; ++i) {
            this.component[i].list(printWriter, n + 2);
        }
    }

    Component findNextFocusComponent(Component component) {
        int n;
        int n2;
        if (component != null) {
            for (n2 = 0; n2 < this.ncomponents && this.component[n2] != component; ++n2) {
            }
            n = n2;
            if (n == 0) {
                n = this.ncomponents;
            }
            ++n2;
        } else {
            n2 = 0;
            n = this.ncomponents;
        }
        for (int i = n2; i != n; ++i) {
            if (i >= this.ncomponents) {
                if (this.parent != null) {
                    return this.parent.findNextFocusComponent(this);
                }
                i -= this.ncomponents;
            }
            if (this.component[i] instanceof Container) {
                Component component2 = this.component[i];
                if ((component2 = component2.findNextFocusComponent(null)) == null) continue;
                return component2;
            }
            if (!this.component[i].isFocusTraversable()) continue;
            return this.component[i];
        }
        return null;
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.printAll(graphics);
        }

        GfxPrintAllVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paintAll(graphics);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.print(graphics);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component component, Graphics graphics) {
            component.paint(graphics);
        }

        GfxPaintVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }
}

