/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public class ComponentOrientation
implements Serializable {
    private static int HORIZONTAL_ID = 1;
    private static int LEFT_TO_RIGHT_ID = 2;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(HORIZONTAL_ID & LEFT_TO_RIGHT_ID);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(HORIZONTAL_ID);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(0);
    int orientation;

    ComponentOrientation(int n) {
        this.orientation = n;
    }

    public boolean isHorizontal() {
        return (this.orientation & HORIZONTAL_ID) != 0;
    }

    public boolean isLeftToRight() {
        return (this.orientation & LEFT_TO_RIGHT_ID) != 0;
    }

    public static ComponentOrientation getOrientation(Locale locale) {
        return LEFT_TO_RIGHT;
    }

    public static ComponentOrientation getOrientation(ResourceBundle resourceBundle) {
        ComponentOrientation componentOrientation;
        Object object;
        try {
            object = resourceBundle.getObject("Orientation");
            componentOrientation = (ComponentOrientation)object;
            if (componentOrientation != null) {
                return componentOrientation;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = resourceBundle.getLocale();
            componentOrientation = ComponentOrientation.getOrientation((Locale)object);
            if (componentOrientation != null) {
                return componentOrientation;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }
}

