/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.Locale;
import java.util.Vector;

public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float TOP_ALIGNMENT = 0.0f;
    static Object treeLock = new String("AWT_TREE_LOCK");
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    boolean visible;
    boolean enabled;
    boolean valid;
    boolean hasFocus;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    Dimension minSize;
    Dimension prefSize;
    boolean newEventsOnly;
    long eventMask;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient ComponentOrientation orientation;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private /* synthetic */ void finit$() {
        this.visible = true;
        this.enabled = true;
        this.eventMask = 8192;
        this.orientation = ComponentOrientation.UNKNOWN;
    }

    protected Component() {
        this.finit$();
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String string) {
        this.nameExplicitlySet = true;
        this.name = string;
    }

    String generateName() {
        return null;
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getGraphicsConfigurationImpl();
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        GraphicsConfiguration graphicsConfiguration;
        if (this.peer != null && (graphicsConfiguration = this.peer.getGraphicsConfiguration()) != null) {
            return graphicsConfiguration;
        }
        if (this.parent != null) {
            return this.parent.getGraphicsConfiguration();
        }
        return null;
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        Toolkit toolkit;
        if (this.peer != null && (toolkit = this.peer.getToolkit()) != null) {
            return toolkit;
        }
        if (this.parent != null) {
            return this.parent.getToolkit();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isDisplayable() {
        if (this.parent != null) {
            return this.parent.isDisplayable();
        }
        return false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        if (!this.visible || this.peer == null) {
            return false;
        }
        return this.parent == null ? true : this.parent.isShowing();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.peer != null) {
            this.peer.setEnabled(bl);
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean bl) {
    }

    public void setVisible(boolean bl) {
        this.show(bl);
    }

    public void show() {
        if (this.peer != null) {
            this.peer.setVisible(true);
        }
        this.visible = true;
    }

    public void show(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (this.peer != null) {
            this.peer.setVisible(false);
        }
        this.visible = false;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent != null) {
            return this.parent.getForeground();
        }
        return null;
    }

    public void setForeground(Color color) {
        if (this.peer != null) {
            this.peer.setForeground(color);
        }
        this.foreground = color;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return null;
    }

    public void setBackground(Color color) {
        if (this.peer != null) {
            this.peer.setBackground(color);
        }
        this.background = color;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        if (this.parent != null) {
            return this.parent.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        if (this.peer != null) {
            this.peer.setFont(font);
        }
        this.font = font;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: Can not determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component not showing");
        }
        return this.peer.getLocationOnScreen();
    }

    public Point location() {
        return this.getLocation();
    }

    public void setLocation(int n, int n2) {
        if (this.x == n && this.y == n2) {
            return;
        }
        this.invalidate();
        this.x = n;
        this.y = n2;
        if (this.peer != null) {
            this.peer.setBounds(n, n2, this.width, this.height);
        }
    }

    public void move(int n, int n2) {
        this.setLocation(n, n2);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension size() {
        return this.getSize();
    }

    public void setSize(int n, int n2) {
        if (this.width == n && this.height == n2) {
            return;
        }
        this.invalidate();
        this.width = n;
        this.height = n2;
        if (this.peer != null) {
            this.peer.setBounds(this.x, this.y, n, n2);
        }
    }

    public void resize(int n, int n2) {
        this.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle bounds() {
        return this.getBounds();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        this.invalidate();
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.peer != null) {
            this.peer.setBounds(n, n2, n3, n4);
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        rectangle.x = this.x;
        rectangle.y = this.y;
        rectangle.width = this.width;
        rectangle.height = this.height;
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        dimension.width = this.width;
        dimension.height = this.height;
        return dimension;
    }

    public Point getLocation(Point point) {
        point.x = this.x;
        point.y = this.y;
        return point;
    }

    public boolean isOpaque() {
        return this.isLightweight() ^ true;
    }

    public boolean isLightweight() {
        return this.peer != null && this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        if (this.peer == null) {
            return new Dimension(this.width, this.height);
        }
        return this.peer.getPreferredSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.peer == null) {
            return new Dimension(this.width, this.height);
        }
        return this.peer.getMinimumSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
    }

    public void layout() {
        this.doLayout();
    }

    public void validate() {
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null && this.parent.valid) {
            this.parent.invalidate();
        }
    }

    public Graphics getGraphics() {
        if (this.peer != null) {
            Graphics graphics = this.peer.getGraphics();
            if (graphics != null) {
                return graphics;
            }
            Container container = this.getParent();
            if (container != null) {
                graphics = container.getGraphics();
                Rectangle rectangle = this.getBounds();
                graphics.setClip(rectangle);
                graphics.translate(rectangle.x, rectangle.y);
                return graphics;
            }
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.getToolkit().getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.peer != null) {
            this.peer.paint(graphics);
        }
        this.paint(graphics);
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.getWidth(), this.getHeight());
    }

    public void repaint(long l) {
        this.repaint(l, 0, 0, this.getWidth(), this.getHeight());
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.repaint(0L, n, n2, n3, n4);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isLightweight() && this.parent != null) {
            if (this.parent != null) {
                this.parent.repaint(l, n + this.getX(), n2 + this.getY(), n3, n4);
            }
            return;
        }
        if (this.peer != null) {
            this.peer.repaint(l, n, n2, n3, n4);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        this.paintAll(graphics);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public Image createImage(ImageProducer imageProducer) {
        return null;
    }

    public Image createImage(int n, int n2) {
        return this.getGraphicsConfiguration().createCompatibleImage(n, n2);
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return false;
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return false;
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return 0;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (this.peer != null) {
            return this.peer.checkImage(image, n, n2, imageObserver);
        }
        return this.getToolkit().checkImage(image, n, n2, imageObserver);
    }

    public boolean contains(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    public boolean inside(int n, int n2) {
        return this.contains(n, n2);
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n, int n2) {
        if (this.contains(n, n2)) {
            return this;
        }
        return null;
    }

    public Component locate(int n, int n2) {
        return this.getComponentAt(n, n2);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
        if (this.peer != null) {
            this.peer.handleEvent(aWTEvent);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 103 && aWTEvent.id >= 100 && (this.componentListener != null || (this.eventMask & 1L) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 402 && aWTEvent.id >= 400 && (this.keyListener != null || (this.eventMask & (long)8) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 506 && aWTEvent.id >= 500 && (this.mouseListener != null || this.mouseMotionListener != null || (this.eventMask & (long)16) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 1005 && aWTEvent.id >= 1004 && (this.focusListener != null || (this.eventMask & (long)4) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 1101 && aWTEvent.id >= 1100 && (this.inputMethodListener != null || (this.eventMask & (long)2048) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 1402 && aWTEvent.id >= 1400 && (this.hierarchyListener != null || this.hierarchyBoundsListener != null || (this.eventMask & 0x8000L) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 801 && aWTEvent.id >= 800 && (this.eventMask & (long)8192) != 0L) {
            this.processEvent(aWTEvent);
        }
    }

    public boolean postEvent(Event event) {
        return false;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        if (this.componentListener != null) {
            this.enableEvents(1L);
        }
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        if (this.focusListener != null) {
            this.enableEvents(4);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, hierarchyListener);
        if (this.hierarchyListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, hierarchyListener);
    }

    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, hierarchyBoundsListener);
        if (this.hierarchyBoundsListener != null) {
            this.enableEvents(32768L);
        }
    }

    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, hierarchyBoundsListener);
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        if (this.keyListener != null) {
            this.enableEvents(8);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        if (this.mouseListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        if (this.mouseMotionListener != null) {
            this.enableEvents(16);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        if (this.inputMethodListener != null) {
            this.enableEvents(2048);
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == Component.class$("java.awt.event.ComponentListener")) {
            return Component.getListenersImpl(clazz, this.componentListener);
        }
        if (clazz == Component.class$("java.awt.event.FocusListener")) {
            return Component.getListenersImpl(clazz, this.focusListener);
        }
        if (clazz == Component.class$("java.awt.event.KeyListener")) {
            return Component.getListenersImpl(clazz, this.keyListener);
        }
        if (clazz == Component.class$("java.awt.event.MouseListener")) {
            return Component.getListenersImpl(clazz, this.mouseListener);
        }
        if (clazz == Component.class$("java.awt.event.MouseMotionListener")) {
            return Component.getListenersImpl(clazz, this.mouseMotionListener);
        }
        if (clazz == Component.class$("java.awt.event.InputMethodListener")) {
            return Component.getListenersImpl(clazz, this.inputMethodListener);
        }
        if (clazz == Component.class$("java.awt.event.HierarchyListener")) {
            return Component.getListenersImpl(clazz, this.hierarchyListener);
        }
        if (clazz == Component.class$("java.awt.event.HierarchyBoundsListener")) {
            return Component.getListenersImpl(clazz, this.hierarchyBoundsListener);
        }
        return Component.getListenersImpl(clazz, null);
    }

    static EventListener[] getListenersImpl(Class clazz, EventListener eventListener) {
        if (!Component.class$("java.util.EventListener").isAssignableFrom(clazz)) {
            throw new ClassCastException();
        }
        Vector vector = new Vector();
        if (eventListener != null) {
            Component.getListenerList(eventListener, vector);
        }
        Object[] objectArray = (EventListener[])Array.newInstance(clazz, vector.size());
        vector.copyInto(objectArray);
        return objectArray;
    }

    static void getListenerList(EventListener eventListener, Vector vector) {
        if (eventListener instanceof AWTEventMulticaster) {
            AWTEventMulticaster aWTEventMulticaster = (AWTEventMulticaster)eventListener;
            Component.getListenerList(aWTEventMulticaster.a, vector);
            Component.getListenerList(aWTEventMulticaster.b, vector);
        } else {
            vector.addElement(eventListener);
        }
    }

    protected final void enableEvents(long l) {
        this.eventMask |= l;
        if (this.isLightweight() && this.parent != null) {
            this.parent.enableEvents(l);
        } else if (this.peer != null) {
            this.peer.setEventMask(this.eventMask);
        }
    }

    protected final void disableEvents(long l) {
        this.eventMask &= l ^ (long)-1;
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        switch (aWTEvent.id) {
            case 503: 
            case 506: {
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                return this.coalescePaintEvents((PaintEvent)aWTEvent, (PaintEvent)aWTEvent2);
            }
        }
        return null;
    }

    private PaintEvent coalescePaintEvents(PaintEvent paintEvent, PaintEvent paintEvent2) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        Rectangle rectangle2 = paintEvent2.getUpdateRect();
        Rectangle rectangle3 = rectangle.union(rectangle2);
        int n = rectangle3.width * rectangle3.height;
        int n2 = rectangle.width * rectangle.height;
        int n3 = rectangle2.width * rectangle2.height;
        if (n > (n2 + n3) * 2) {
            return null;
        }
        paintEvent2.setUpdateRect(rectangle3);
        return paintEvent2;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof PaintEvent) {
            this.processPaintEvent((PaintEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            if (aWTEvent.id == 503 || aWTEvent.id == 506) {
                this.processMouseMotionEvent((MouseEvent)aWTEvent);
            } else {
                this.processMouseEvent((MouseEvent)aWTEvent);
            }
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        } else if (aWTEvent instanceof HierarchyEvent) {
            if (aWTEvent.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)aWTEvent);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (this.componentListener == null) {
            return;
        }
        switch (componentEvent.id) {
            case 103: {
                this.componentListener.componentHidden(componentEvent);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(componentEvent);
                break;
            }
            case 101: {
                this.componentListener.componentResized(componentEvent);
                break;
            }
            case 102: {
                this.componentListener.componentShown(componentEvent);
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusListener == null) {
            return;
        }
        switch (focusEvent.id) {
            case 1004: {
                this.focusListener.focusGained(focusEvent);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(focusEvent);
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyListener == null) {
            return;
        }
        switch (keyEvent.id) {
            case 401: {
                this.keyListener.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(keyEvent);
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseListener == null) {
            return;
        }
        switch (mouseEvent.id) {
            case 500: {
                this.mouseListener.mouseClicked(mouseEvent);
                break;
            }
            case 504: {
                this.mouseListener.mouseEntered(mouseEvent);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(mouseEvent);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(mouseEvent);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (mouseEvent.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(mouseEvent);
            }
        }
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (inputMethodEvent.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(inputMethodEvent);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(inputMethodEvent);
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (hierarchyEvent.id == 1400) {
            this.hierarchyListener.hierarchyChanged(hierarchyEvent);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (hierarchyEvent.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(hierarchyEvent);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(hierarchyEvent);
            }
        }
    }

    private void processPaintEvent(PaintEvent paintEvent) {
        if (this.peer == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        Rectangle rectangle = paintEvent.getUpdateRect();
        graphics.setClip(rectangle);
        switch (paintEvent.id) {
            case 800: {
                this.paint(graphics);
                break;
            }
            case 801: {
                this.update(graphics);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown paint event");
            }
        }
    }

    public boolean handleEvent(Event event) {
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseEnter(Event event, int n, int n2) {
        return false;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        return false;
    }

    public boolean keyDown(Event event, int n) {
        return false;
    }

    public boolean keyUp(Event event, int n) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createComponent(this);
        }
        this.addNotifyContainerChildren();
        this.peer.setEventMask(this.eventMask);
    }

    void addNotifyContainerChildren() {
    }

    public void removeNotify() {
        if (this.peer != null) {
            this.peer.dispose();
        }
        this.peer = null;
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        return this.enabled && this.visible && (this.peer == null || this.peer.isFocusTraversable());
    }

    public void requestFocus() {
        if (this.peer != null) {
            this.peer.requestFocus();
        }
    }

    Component findNextFocusComponent(Component component) {
        return null;
    }

    public void transferFocus() {
        Component component = this.parent == null ? this.findNextFocusComponent(null) : this.parent.findNextFocusComponent(this);
        if (component != null && component != this) {
            component.requestFocus();
        }
    }

    public void nextFocus() {
        this.transferFocus();
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popupMenu);
    }

    public synchronized void remove(MenuComponent menuComponent) {
        this.popups.removeElement(menuComponent);
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append(this.width);
        stringBuffer.append("x");
        stringBuffer.append(this.height);
        stringBuffer.append("+");
        stringBuffer.append(this.x);
        stringBuffer.append("+");
        stringBuffer.append(this.y);
        if (!this.isValid()) {
            stringBuffer.append(",invalid");
        }
        if (!this.isVisible()) {
            stringBuffer.append(",invisible");
        }
        if (!this.isEnabled()) {
            stringBuffer.append(",disabled");
        }
        if (!this.isOpaque()) {
            stringBuffer.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            stringBuffer.append(",doublebuffered");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(' ');
        }
        printStream.println(this.toString());
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print(' ');
        }
        printWriter.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        this.orientation = componentOrientation;
    }

    public ComponentOrientation getComponentOrientation() {
        return this.orientation;
    }
}

