/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.util.ArrayList;

public class Choice
extends Component
implements ItemSelectable {
    private ItemListener listeners;
    ArrayList items = new ArrayList();
    int selected = -1;

    public synchronized void add(String string) {
        if (string == null) {
            throw new IllegalArgumentException("item must be non-null");
        }
        this.items.add(string);
        int n = this.items.size() - 1;
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.add(string, n);
        }
        if (n == 0) {
            this.select(0);
        }
    }

    public void addItem(String string) {
        this.add(string);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, itemListener);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
    }

    public int countItems() {
        return this.getItemCount();
    }

    public String getItem(int n) {
        return (String)this.items.get(n);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        if (this.selected == -1) {
            return null;
        }
        return (String)this.items.get(this.selected);
    }

    public synchronized Object[] getSelectedObjects() {
        Object[] objectArray = this.selected != -1 ? new Object[]{this.items.get(this.selected)} : new Object[]{};
        return objectArray;
    }

    public synchronized void insert(String string, int n) {
        if (n > this.items.size()) {
            n = this.items.size();
        }
        this.items.add(n, string);
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.add(string, n);
        }
        if (this.items.size() == 1 || this.selected >= n) {
            this.select(0);
        }
    }

    protected String paramString() {
        return "Choice[selected=" + this.selected + "]";
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.listeners != null) {
            this.listeners.itemStateChanged(itemEvent);
        }
    }

    public synchronized void remove(String string) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.items.get(i))) continue;
            this.remove(i);
            break;
        }
        throw new IllegalArgumentException("item \"" + string + "\" not in Choice");
    }

    public synchronized void remove(int n) {
        this.items.remove(n);
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.remove(n);
        }
        if (n == this.selected) {
            this.select(0);
        } else if (this.selected > n) {
            this.selected += -1;
        }
    }

    public synchronized void removeAll() {
        int n = this.items.size();
        this.items.clear();
        this.selected = -1;
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            for (int i = 0; i < n; ++i) {
                choicePeer.remove(0);
            }
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, itemListener);
    }

    public synchronized void select(String string) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.items.get(i))) continue;
            this.select(i);
            break;
        }
    }

    public synchronized void select(int n) {
        if (n < 0 || n > this.items.size()) {
            throw new IllegalArgumentException("index out of range");
        }
        this.selected = n;
        if (this.peer != null) {
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            choicePeer.select(n);
        }
    }
}

