/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;

public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable {
    String label;
    boolean state;
    ItemListener listeners;

    public CheckboxMenuItem() {
        this(null, false);
    }

    public CheckboxMenuItem(String string) {
        this(string, false);
    }

    public CheckboxMenuItem(String string, boolean bl) {
        this.label = string;
        this.state = bl;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, itemListener);
    }

    public void addNotify() {
        if (this.peer != null) {
            this.peer = Toolkit.getDefaultToolkit().createCheckboxMenuItem(this);
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = this.state ? new Object[]{this.label} : new Object[]{};
        return objectArray;
    }

    public boolean getState() {
        return this.state;
    }

    public String paramString() {
        return "[" + this.getClass().getName() + "state=" + this.state + "," + "label=" + this.label + "]";
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.listeners != null) {
            this.listeners.itemStateChanged(itemEvent);
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, itemListener);
    }

    public void setState(boolean bl) {
        this.state = bl;
        if (this.peer != null) {
            CheckboxMenuItemPeer checkboxMenuItemPeer = (CheckboxMenuItemPeer)this.peer;
            checkboxMenuItemPeer.setState(bl);
        }
    }
}

