/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;

public class Checkbox
extends Component
implements ItemSelectable {
    private ItemListener listeners;
    String label;
    CheckboxGroup group;
    boolean state;

    public Checkbox() {
        this(null, null, false);
    }

    public Checkbox(String string) {
        this(string, null, false);
    }

    public Checkbox(String string, boolean bl) {
        this(string, null, bl);
    }

    public Checkbox(String string, boolean bl, CheckboxGroup checkboxGroup) {
        this(string, checkboxGroup, bl);
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl) {
        this.label = string;
        this.group = checkboxGroup;
        this.state = bl;
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.listeners = AWTEventMulticaster.add(this.listeners, itemListener);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray = this.state ? new Object[]{this.label} : new Object[]{};
        return objectArray;
    }

    public boolean getState() {
        return this.state;
    }

    protected String paramString() {
        return "Checkbox[state=" + this.state + "," + "label=" + this.label + "," + "group=" + this.group + "]";
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.listeners != null) {
            this.listeners.itemStateChanged(itemEvent);
        }
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.listeners = AWTEventMulticaster.remove(this.listeners, itemListener);
    }

    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        this.group = checkboxGroup;
        if (this.peer != null) {
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            checkboxPeer.setCheckboxGroup(checkboxGroup);
        }
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        if (this.peer != null) {
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            checkboxPeer.setLabel(string == null ? "" : string);
        }
    }

    public void setState(boolean bl) {
        this.state = bl;
        if (this.peer != null) {
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            checkboxPeer.setState(bl);
        }
    }
}

