/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CardLayout
implements LayoutManager2,
Serializable {
    private int hgap;
    private int vgap;
    private Hashtable map;
    private int FIRST;
    private int LAST;
    private int NEXT;
    private int PREV;
    private int NONE;
    private int MIN;
    private int MAX;
    private int PREF;

    private /* synthetic */ void finit$() {
        this.FIRST = 0;
        this.LAST = 1;
        this.NEXT = 2;
        this.PREV = 3;
        this.NONE = 4;
        this.MIN = 0;
        this.MAX = 1;
        this.PREF = 2;
    }

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int n, int n2) {
        this.finit$();
        this.hgap = n;
        this.vgap = n2;
        this.map = new Hashtable();
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("Object " + object + " is not a string");
        }
        this.map.put(object, component);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void first(Container container) {
        this.gotoComponent(container, this.FIRST, null);
    }

    public int getHgap() {
        return this.hgap;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void invalidateLayout(Container container) {
    }

    public void last(Container container) {
        this.gotoComponent(container, this.LAST, null);
    }

    public void layoutContainer(Container container) {
        int n = container.width;
        int n2 = container.height;
        Insets insets = container.getInsets();
        int n3 = container.ncomponents;
        Component[] componentArray = container.component;
        for (int i = 0; i < n3; ++i) {
            if (!componentArray[i].isVisible()) continue;
            componentArray[i].setBounds(this.hgap + insets.left, this.vgap + insets.top, n - 2 * this.hgap - insets.left - insets.right, n2 - 2 * this.vgap - insets.top - insets.bottom);
            break;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.getSize(container, this.MAX);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, this.MIN);
    }

    public void next(Container container) {
        this.gotoComponent(container, this.NEXT, null);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, this.PREF);
    }

    public void previous(Container container) {
        this.gotoComponent(container, this.PREV, null);
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.map.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (this.map.get(object) != component) continue;
            this.map.remove(object);
            break;
        }
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void show(Container container, String string) {
        Object object = this.map.get(string);
        if (object != null) {
            this.gotoComponent(container, this.NONE, (Component)object);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.hgap + "," + this.vgap + "]";
    }

    private void gotoComponent(Container container, int n, Component component) {
        int n2 = container.getComponentCount();
        Component[] componentArray = container.component;
        int n3 = -1;
        if (n == this.FIRST) {
            n3 = 0;
        } else if (n == this.LAST) {
            n3 = n2;
        } else if (n >= 0) {
            n3 = n;
        }
        for (int i = 0; i < n2; ++i) {
            if (component != null && component == componentArray[i]) {
                n3 = i;
            }
            if (!componentArray[i].isVisible()) continue;
            if (n == this.NEXT) {
                n3 = i + 1;
                if (n3 == n2) {
                    n3 = n2 - 1;
                }
            } else if (n == this.PREV) {
                n3 = i - 1;
                if (n3 < 0) {
                    n3 = 0;
                }
            } else if (n3 == i) {
                return;
            }
            componentArray[i].setVisible(false);
            if (n3 >= 0) break;
        }
        componentArray[n3].setVisible(true);
    }

    private Dimension getSize(Container container, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = container.ncomponents;
        Component[] componentArray = container.component;
        for (int i = 0; i < n4; ++i) {
            Dimension dimension = n == this.MIN ? componentArray[i].getMinimumSize() : (n == this.MAX ? componentArray[i].getMaximumSize() : componentArray[i].getPreferredSize());
            n2 = Math.max(dimension.width, n2);
            n3 = Math.max(dimension.height, n3);
        }
        Insets insets = container.getInsets();
        n3 += 2 * this.vgap + insets.bottom + insets.top;
        if ((n2 += 2 * this.hgap + insets.right + insets.left) < 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        return new Dimension(n2, n3);
    }
}

