/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    int hgap;
    int vgap;
    Component north;
    Component south;
    Component east;
    Component west;
    Component center;
    static final Dimension DIM_0;
    static final Dimension DIM_MAX;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null || CENTER.equals(object)) {
            this.center = component;
        } else if (NORTH.equals(object)) {
            this.north = component;
        } else if (SOUTH.equals(object)) {
            this.south = component;
        } else if (EAST.equals(object)) {
            this.east = component;
        } else if (WEST.equals(object)) {
            this.west = component;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void removeLayoutComponent(Component component) {
        if (this.center == component) {
            this.center = null;
        } else if (this.north == component) {
            this.north = null;
        } else if (this.south == component) {
            this.south = null;
        } else if (this.east == component) {
            this.east = null;
        } else if (this.west == component) {
            this.west = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calcSize(this.getMinimumSize(this.center), this.getMinimumSize(this.north), this.getMinimumSize(this.south), this.getMinimumSize(this.east), this.getMinimumSize(this.west), container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calcSize(this.getPreferredSize(this.center), this.getPreferredSize(this.north), this.getPreferredSize(this.south), this.getPreferredSize(this.east), this.getPreferredSize(this.west), container);
    }

    public Dimension maximumLayoutSize(Container container) {
        return (Dimension)DIM_MAX.clone();
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = this.getPreferredSize(this.center);
        Dimension dimension2 = this.getPreferredSize(this.north);
        Dimension dimension3 = this.getPreferredSize(this.south);
        Dimension dimension4 = this.getPreferredSize(this.east);
        Dimension dimension5 = this.getPreferredSize(this.west);
        Dimension dimension6 = container.getSize();
        int n = insets.left;
        int n2 = n + dimension5.width + this.hgap;
        int n3 = dimension6.width - insets.right - dimension4.width;
        int n4 = dimension6.width - insets.right - insets.left;
        int n5 = insets.top;
        int n6 = n5 + dimension2.height + this.vgap;
        int n7 = dimension6.height - insets.bottom - dimension3.height;
        int n8 = n7 - n6 - this.vgap;
        this.setBounds(this.center, n2, n6, n3 - n2 - this.hgap, n8);
        this.setBounds(this.north, n, n5, n4, dimension2.height);
        this.setBounds(this.south, n, n7, n4, dimension3.height);
        this.setBounds(this.west, n, n6, dimension5.width, n8);
        this.setBounds(this.east, n3, n6, dimension4.width, n8);
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    void setBounds(Component component, int n, int n2, int n3, int n4) {
        if (component == null) {
            return;
        }
        component.setBounds(n, n2, n3, n4);
    }

    Dimension getMinimumSize(Component component) {
        if (component == null) {
            return DIM_0;
        }
        return component.getMinimumSize();
    }

    Dimension getPreferredSize(Component component) {
        if (component == null) {
            return DIM_0;
        }
        return component.getPreferredSize();
    }

    Dimension calcSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(dimension.width + dimension4.width + dimension5.width + this.hgap * 2 + insets.left + insets.right, dimension.height + dimension2.height + dimension3.height + this.vgap * 2 + insets.top + insets.bottom);
    }

    static {
        NORTH = NORTH;
        SOUTH = SOUTH;
        EAST = EAST;
        WEST = WEST;
        CENTER = CENTER;
        BEFORE_FIRST_LINE = BEFORE_FIRST_LINE;
        AFTER_LAST_LINE = AFTER_LAST_LINE;
        BEFORE_LINE_BEGINS = BEFORE_LINE_BEGINS;
        AFTER_LINE_ENDS = AFTER_LINE_ENDS;
        DIM_0 = new Dimension(0, 0);
        DIM_MAX = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

