/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class SHA1PRNG
implements Serializable {
    MessageDigest digest;
    byte[] seed;
    byte[] data;
    int seedpos;
    int datapos;

    public SHA1PRNG() {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Failed to find SHA Message Digest: " + noSuchAlgorithmException);
            noSuchAlgorithmException.printStackTrace();
        }
        this.seed = new byte[20];
        this.seedpos = 0;
        this.data = new byte[40];
        this.datapos = 0;
        new Random().nextBytes(this.seed);
        byte[] byArray = this.digest.digest(this.data);
        System.arraycopy(byArray, 0, this.data, 0, 20);
    }

    public void engineSetSeed(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.seed[this.seedpos++ % 20] = this.seed[this.seedpos++ % 20] ^ byArray[i];
        }
        this.seedpos %= 20;
    }

    public void engineNextBytes(byte[] byArray) {
        if (byArray.length < 20 - this.datapos) {
            System.arraycopy(byArray, 0, this.data, this.datapos, byArray.length);
            this.datapos += byArray.length;
            return;
        }
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 20 - this.datapos;
            System.arraycopy(byArray, n2, this.data, this.datapos, n3);
            n2 += n3;
            this.datapos += n3;
            if (this.datapos < 20) continue;
            System.arraycopy(this.seed, 0, this.data, 20, 20);
            byte[] byArray2 = this.digest.digest(this.data);
            System.arraycopy(byArray2, 0, this.data, 0, 20);
            this.datapos = 0;
        }
    }

    public byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }
}

