/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class TypeSignature {
    public static String getEncodingOfClass(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unknown primitive class " + clazz);
        }
        if (clazz.isArray()) {
            return '[' + TypeSignature.getEncodingOfClass(clazz.getComponentType());
        }
        String string = clazz.getName();
        int n = string.length();
        char[] cArray = new char[n + 2];
        cArray[0] = 76;
        string.getChars(0, n, cArray, 1);
        for (int i = 1; i <= n; ++i) {
            if (cArray[i] != '.') continue;
            cArray[i] = 47;
        }
        cArray[i] = 59;
        return new String(cArray);
    }

    public static Class getClassForEncoding(String string) throws ClassNotFoundException {
        if (string.equals("B")) {
            return Byte.TYPE;
        }
        if (string.equals("C")) {
            return Character.TYPE;
        }
        if (string.equals("D")) {
            return Double.TYPE;
        }
        if (string.equals("F")) {
            return Float.TYPE;
        }
        if (string.equals("I")) {
            return Integer.TYPE;
        }
        if (string.equals("J")) {
            return Long.TYPE;
        }
        if (string.equals("S")) {
            return Short.TYPE;
        }
        if (string.equals("Z")) {
            return Boolean.TYPE;
        }
        if (string.charAt(0) == 'L') {
            return Class.forName(string.substring(1, string.length() - 1).replace('/', '.'));
        }
        if (string.charAt(0) == '[') {
            int n = string.lastIndexOf(91);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (string3.charAt(0) == 'L') {
                string3 = string3.replace('/', '.');
            }
            return Class.forName(string2 + string3);
        }
        throw new ClassNotFoundException("Type code cannot be parsed as a valid class name");
    }

    public static String getEncodingOfMethod(Method method) {
        String string = TypeSignature.getEncodingOfClass(method.getReturnType());
        Class[] classArray = method.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 2;
        for (int i = 0; i < classArray.length; ++i) {
            String string2 = TypeSignature.getEncodingOfClass(classArray[i]);
            n += string2.length();
            stringArray[i] = string2;
        }
        StringBuffer stringBuffer = new StringBuffer(n += string.length());
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(')');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String getEncodingOfConstructor(Constructor constructor) {
        Class[] classArray = constructor.getParameterTypes();
        String[] stringArray = new String[classArray.length];
        int n = 3;
        for (int i = 0; i < classArray.length; ++i) {
            String string = TypeSignature.getEncodingOfClass(classArray[i]);
            n += string.length();
            stringArray[i] = string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    public static String getEncodingOfMember(Member member) {
        if (member instanceof Constructor) {
            return TypeSignature.getEncodingOfConstructor((Constructor)member);
        }
        if (member instanceof Method) {
            return TypeSignature.getEncodingOfMethod((Method)member);
        }
        return TypeSignature.getEncodingOfClass(((Field)member).getType());
    }
}

