/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.text;

import gnu.gcj.text.BaseBreakIterator;
import java.text.CharacterIterator;

public class CharacterBreakIterator
extends BaseBreakIterator {
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int highSurrogateStart = 55296;
    private static final int highSurrogateEnd = 56319;
    private static final int lowSurrogateStart = 56320;
    private static final int lowSurrogateEnd = 57343;

    public Object clone() {
        return new CharacterBreakIterator(this);
    }

    public CharacterBreakIterator() {
        this.iter = null;
    }

    private CharacterBreakIterator(CharacterBreakIterator characterBreakIterator) {
        this.iter = (CharacterIterator)characterBreakIterator.iter.clone();
    }

    private final boolean isL(char c) {
        return c > '\u10ff' && c <= '\u1113';
    }

    private final boolean isV(char c) {
        return c > '\u1160' && c <= '\u1176';
    }

    private final boolean isT(char c) {
        return c > '\u11a6' && c <= '\u11c3';
    }

    private final boolean isLVT(char c) {
        return this.isL(c) || this.isV(c) || this.isT(c);
    }

    private final boolean isHighSurrogate(char c) {
        return c > '\ud7ff' && c <= '\udbff';
    }

    private final boolean isLowSurrogate(char c) {
        return c > '\udbff' && c <= '\udfff';
    }

    public int next() {
        int n;
        char c;
        int n2 = this.iter.getEndIndex();
        if (this.iter.getIndex() == n2) {
            return -1;
        }
        char c2 = '\uffff';
        while (this.iter.getIndex() < n2 && (c = this.iter.next()) != '\uffff' && (n = Character.getType(c)) != 14) {
            int n3;
            char c3 = this.iter.next();
            this.iter.previous();
            if (c3 == '\uffff' || (n3 = Character.getType(c3)) != 6 && !this.isLowSurrogate(c3) && !this.isLVT(c3) || !this.isLVT(c) && this.isLVT(c3) || this.isL(c) && !this.isLVT(c3) && n3 != 6 || this.isV(c) && !this.isV(c3) && !this.isT(c3) && n3 != 6 || this.isT(c) && !this.isT(c3) && n3 != 6 || !this.isHighSurrogate(c) && this.isLowSurrogate(c3) || this.isHighSurrogate(c) && !this.isLowSurrogate(c3) || !this.isHighSurrogate(c2) && this.isLowSurrogate(c)) break;
            c2 = c;
        }
        return this.iter.getIndex();
    }

    public int previous() {
        int n;
        char c;
        if (this.iter.getIndex() == this.iter.getBeginIndex()) {
            return -1;
        }
        int n2 = this.iter.getBeginIndex();
        while (this.iter.getIndex() >= this.iter.getBeginIndex() && (c = this.iter.previous()) != '\uffff' && ((n = Character.getType(c)) == 6 || this.isLowSurrogate(c) || this.isLVT(c))) {
            int n3;
            char c2 = this.iter.previous();
            if (c2 == '\uffff') {
                this.iter.next();
                break;
            }
            char c3 = this.iter.previous();
            this.iter.next();
            this.iter.next();
            if (!(c3 == '\uffff' || (n3 = Character.getType(c2)) == 14 || this.isLVT(c) && !this.isLVT(c2) || !this.isLVT(c) && n != 6 && this.isL(c2) || !this.isV(c) && !this.isT(c) && n != 6 && this.isV(c2) || !this.isT(c) && n != 6 && this.isT(c2) || this.isLowSurrogate(c) && !this.isHighSurrogate(c2) || !this.isLowSurrogate(c) && this.isHighSurrogate(c2)) && (!this.isLowSurrogate(c2) || this.isHighSurrogate(c3))) continue;
            break;
        }
        return this.iter.getIndex();
    }
}

