/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.protocol.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Connection
extends HttpURLConnection {
    protected Socket sock;
    private static Hashtable defRequestProperties = new Hashtable();
    private Hashtable requestProperties;
    private Hashtable hdrHash;
    private Vector hdrVec;
    private BufferedInputStream bufferedIn;

    private /* synthetic */ void finit$() {
        this.sock = null;
        this.hdrHash = new Hashtable();
        this.hdrVec = new Vector();
    }

    public Connection(URL uRL) {
        super(uRL);
        this.finit$();
        this.requestProperties = (Hashtable)defRequestProperties.clone();
    }

    public static void setDefaultRequestProperty(String string, String string2) {
        defRequestProperties.put(string, string2);
    }

    public static String getDefaultRequestProperty(String string) {
        return (String)defRequestProperties.get(string);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Connection already established.");
        }
        this.requestProperties.put(string, string2);
    }

    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalAccessError("Connection already established.");
        }
        return (String)this.requestProperties.get(string);
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        InetAddress inetAddress = InetAddress.getByName(this.url.getHost());
        int n = this.url.getPort();
        if (n == -1) {
            n = 80;
        }
        this.sock = new Socket(inetAddress, n);
        PrintWriter printWriter = new PrintWriter(this.sock.getOutputStream());
        printWriter.print(this.getRequestMethod() + " " + this.url.getFile() + " HTTP/1.0\n");
        printWriter.print("Host: " + this.url.getHost() + ":" + n + "\n");
        Enumeration enumeration = this.requestProperties.keys();
        Enumeration enumeration2 = this.requestProperties.elements();
        while (enumeration.hasMoreElements()) {
            printWriter.print(enumeration.nextElement() + ": " + enumeration2.nextElement() + "\n");
        }
        printWriter.print("\n");
        printWriter.flush();
        this.getHttpHeaders();
        this.connected = true;
    }

    public void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
        }
    }

    public boolean usingProxy() {
        throw new InternalError("HttpURLConnection.usingProxy not implemented");
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doInput) {
            throw new ProtocolException("Can't open InputStream if doInput is false");
        }
        return this.bufferedIn;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.doOutput) {
            throw new ProtocolException("Can't open OutputStream if doOutput is false");
        }
        return this.sock.getOutputStream();
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (String)this.hdrHash.get(string.toLowerCase());
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (n < this.hdrVec.size()) {
            return this.getField((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (n < this.hdrVec.size()) {
            return this.getKey((String)this.hdrVec.elementAt(n));
        }
        return null;
    }

    private String getKey(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private String getField(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(n + 1).trim();
        }
        return string;
    }

    private void getHttpHeaders() throws IOException {
        this.bufferedIn = new BufferedInputStream(this.sock.getInputStream());
        int n = 100;
        byte[] byArray = new byte[n];
        String string = "";
        boolean bl = false;
        byte[] byArray2 = new byte[]{10};
        while (true) {
            int n2;
            if (byArray2[0] != 10) {
                string = string + '\r' + new String(byArray2, 0, 1);
            }
            for (n2 = 0; n2 < n; ++n2) {
                byArray[n2] = (byte)this.bufferedIn.read();
                if (byArray[n2] == -1) {
                    throw new IOException("Malformed HTTP header");
                }
                if (byArray[n2] != 13) continue;
                this.bufferedIn.read(byArray2, 0, 1);
                if (byArray2[0] != 10) break;
                bl = true;
                break;
            }
            string = string + new String(byArray, 0, n2);
            if (!bl) continue;
            if (string.length() == 0) break;
            this.hdrVec.addElement(string);
            String string2 = this.getKey(string);
            if (string2 != null) {
                this.hdrHash.put(string2.toLowerCase(), this.getField(string));
            }
            string = "";
            byArray2[0] = 10;
            bl = false;
        }
    }
}

