/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.j2d;

import gnu.awt.j2d.AbstractGraphicsState;
import gnu.awt.j2d.DirectRasterGraphics;
import gnu.awt.j2d.MappedRaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;

public class IntegerGraphicsState
extends AbstractGraphicsState {
    int tx;
    int ty;
    DirectRasterGraphics directGfx;
    Shape clip;

    public IntegerGraphicsState(DirectRasterGraphics directRasterGraphics) {
        this.directGfx = directRasterGraphics;
    }

    public Object clone() {
        IntegerGraphicsState integerGraphicsState = (IntegerGraphicsState)super.clone();
        integerGraphicsState.directGfx = (DirectRasterGraphics)this.directGfx.clone();
        return integerGraphicsState;
    }

    public void dispose() {
        DirectRasterGraphics directRasterGraphics = this.directGfx;
        this.directGfx = null;
        if (directRasterGraphics != null) {
            directRasterGraphics.dispose();
        }
        super.dispose();
    }

    public void setColor(Color color) {
        this.directGfx.setColor(color);
    }

    public void setPaintMode() {
        this.directGfx.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.directGfx.setXORMode(color);
    }

    public void setFont(Font font) {
        this.directGfx.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.directGfx.getFontMetrics(font);
    }

    public void setClip(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)((Rectangle)shape).clone();
            rectangle.x += this.tx;
            rectangle.y += this.ty;
            this.clip = rectangle;
            this.directGfx.setClip(rectangle);
            return;
        }
        String string = "translating clip shape " + shape + " into device " + "coordinate space has not been implemented yet";
        throw new UnsupportedOperationException(string);
    }

    public Shape getClip() {
        if (this.clip instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)this.clip;
            rectangle.x -= this.tx;
            rectangle.y -= this.ty;
            return rectangle;
        }
        String string = "translating clip shape " + this.clip + " into user " + "coordinate space has not been implemented yet";
        throw new UnsupportedOperationException(string);
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = this.clip.getBounds();
        rectangle.x -= this.tx;
        rectangle.y -= this.ty;
        return rectangle;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.directGfx.copyArea(n + this.tx, n2 + this.ty, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.directGfx.drawLine(n + this.tx, n2 + this.ty, n3 + this.tx, n4 + this.ty);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.directGfx.fillRect(n + this.tx, n2 + this.ty, n3, n4);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.directGfx.setColor(this.frontend.getBackground());
        this.directGfx.fillRect(n + this.tx, n2 + this.ty, n3, n4);
        this.directGfx.setColor(this.frontend.getColor());
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.directGfx.drawArc(n + this.tx, n2 + this.ty, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.directGfx.fillArc(n + this.tx, n2 + this.ty, n3, n4, n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (this.tx == 0 || this.ty == 0) {
            this.directGfx.drawPolyline(nArray, nArray2, n);
            return;
        }
        throw new UnsupportedOperationException("translate not implemented");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.tx == 0 || this.ty == 0) {
            this.directGfx.drawPolygon(nArray, nArray2, n);
            return;
        }
        throw new UnsupportedOperationException("translate not implemented");
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        if (this.tx == 0 || this.ty == 0) {
            this.directGfx.fillPolygon(nArray, nArray2, n);
            return;
        }
        throw new UnsupportedOperationException("translate not implemented");
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        n += this.tx;
        n2 += this.ty;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            Object object = bufferedImage.getProperty("java.awt.GraphicsConfiguration");
            if (object == this.frontend.config) {
                return this.directGfx.drawImage(image, n, n2, imageObserver);
            }
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            MappedRaster mappedRaster = this.directGfx.mapRaster(rectangle);
            ColorModel colorModel = mappedRaster.getColorModel();
            WritableRaster writableRaster = mappedRaster.getRaster();
            int n5 = n + n3;
            int n6 = n2 + n4;
            Object object2 = null;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n7 = bufferedImage.getRGB(j, i);
                    int n8 = (n7 >>> 24 & 0xFF) + 1;
                    int n9 = (n7 >>> 16 & 0xFF) + 1;
                    int n10 = (n7 >>> 8 & 0xFF) + 1;
                    int n11 = (n7 & 0xFF) + 1;
                    object2 = writableRaster.getDataElements(j + n, i + n2, object2);
                    int n12 = colorModel.getRGB(object2);
                    int n13 = (n12 >>> 16 & 0xFF) + 1;
                    int n14 = (n12 >>> 8 & 0xFF) + 1;
                    int n15 = (n12 & 0xFF) + 1;
                    int n16 = 256 - n8;
                    n13 = (n9 * n8 + n13 * n16 >>> 8) - 1;
                    n14 = (n10 * n8 + n14 * n16 >>> 8) - 1;
                    n15 = (n11 * n8 + n15 * n16 >>> 8) - 1;
                    n12 = n13 << 16 | n14 << 8 | n15;
                    object2 = colorModel.getDataElements(n12, object2);
                    writableRaster.setDataElements(j + n, i + n2, object2);
                }
            }
            this.directGfx.unmapRaster(mappedRaster);
            return true;
        }
        throw new UnsupportedOperationException("drawing image " + image + "not implemented");
    }

    public void draw(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.directGfx.drawRect(rectangle.x + this.tx, rectangle.y + this.ty, rectangle.width, rectangle.height);
            return;
        }
        throw new UnsupportedOperationException("shape not implemented");
    }

    public void fill(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            this.directGfx.fillRect(rectangle.x + this.tx, rectangle.y + this.ty, rectangle.width, rectangle.height);
            return;
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void drawString(String string, int n, int n2) {
        this.directGfx.drawString(string, n + this.tx, n2 + this.ty);
    }

    public void drawString(String string, float f, float f2) {
        this.drawString(string, (int)f, (int)f2);
    }

    public void translate(int n, int n2) {
        this.tx += n;
        this.ty += n2;
    }

    public void translate(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void rotate(double d) {
        if (d == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void rotate(double d, double d2, double d3) {
        if (d == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void scale(double d, double d2) {
        if (d == 1.0 && d2 == 1.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void shear(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    private void needAffineTransform() {
        throw new UnsupportedOperationException("state with affine transform not implemented");
    }
}

