	/**********************************************************
	* Copyright (C) Data General Corporation, 1984 - 1995	  *
	* All Rights Reserved.					  *
	* Licensed Material-Property of Data General Corporation. *
	* This software is made available solely pursuant to the  *
	* terms of a DGC license agreement which governs its use. *
	**********************************************************/

/*  <@(#) math.h,v	6.30.1.4>  */

/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	#ident	"@(#)head:math.h	2.11.1.27"		*/

#ifndef _MATH_H	/* Prevent multiple inclusions of this file */
#define _MATH_H

#ifndef ___int_features_h
#include <sys/_int_features.h>
#endif

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ABI || \
     _IX86_ANY_DG || _IX86_UW || _IX86_SCO )

#ifdef _USING_ANSI_C_OR_POSIX_OR_XPG3_OR_SYSV3_OR_BSD_OR_DGUX

#if _IX86_M88KDATA_DG_ANY_C
  #pragma datarep(ix86)
  #pragma esnameprefix(off)
#endif

_EXTERN _IX86_M88KDATA_SCALAR(double)		_MaXdOuB, _MiNdOuB;
_EXTERN _IX86_M88KDATA_SCALAR(float)		_MaXfLoA, _MiNfLoA;

#if _IX86_M88KDATA_DG_ANY_C
  #pragma esnameprefix(on)
  #pragma datarep(m88k)
#endif

#ifndef __INT_HUGE_VAL_H
#include <_int_huge_val.h>
#endif

_EXTERN double	acos  		_PROTO_ARGS((double));
_EXTERN double	asin  		_PROTO_ARGS((double));
_EXTERN double	atan  		_PROTO_ARGS((double));
_EXTERN double	atan2 		_PROTO_ARGS((double, double));
_EXTERN double	ceil  		_PROTO_ARGS((double));
_EXTERN double	cos   		_PROTO_ARGS((double));
_EXTERN double	cosh  		_PROTO_ARGS((double));
_EXTERN double	exp   		_PROTO_ARGS((double));
_EXTERN double	fabs  		_PROTO_ARGS((double));
_EXTERN double	floor 		_PROTO_ARGS((double));
_EXTERN double	fmod  		_PROTO_ARGS((double, double));
_EXTERN double	log   		_PROTO_ARGS((double));
_EXTERN double	log10 		_PROTO_ARGS((double));
_EXTERN double	pow   		_PROTO_ARGS((double, double));
_EXTERN double	sin   		_PROTO_ARGS((double));
_EXTERN double	sinh  		_PROTO_ARGS((double));
_EXTERN double	sqrt  		_PROTO_ARGS((double));
_EXTERN double	tan   		_PROTO_ARGS((double));
_EXTERN double	tanh  		_PROTO_ARGS((double));

#endif /* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
          _IX86_ABI || _IX86_ANY_DG || _IX86_UW || _IX86_SCO ) */

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
     _IX86_UW || _IX86_SCO )

_EXTERN double	frexp 		_PROTO_ARGS((double, int *));
_EXTERN double	ldexp 		_PROTO_ARGS((double, int));
_EXTERN double	modf  		_PROTO_ARGS((double, double *));

#endif	/* #ifdef _USING_ANSI_C_OR_POSIX_OR_XPG3_OR_SYSV3_OR_BSD_OR_DGUX */

#ifdef _USING_SYSV4_OR_DGUX

#if _IX86_M88KDATA_DG_ANY_C
  #pragma datarep(ix86)
  #pragma esnameprefix(off)
#endif

enum version		{ c_issue_4, ansi_1, strict_ansi };

_EXTERN _CONST _IX86_M88KDATA_SCALAR(enum version)	_lib_version;

#if _IX86_M88KDATA_DG_ANY_C
  #pragma esnameprefix(on)
  #pragma datarep(m88k)
#endif


#endif	/* #ifdef _USING_SYSV4_OR_DGUX */

#endif	/* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
           _IX86_ANY_DG || _IX86_UW || _IX86_SCO ) */

#if (_M88K_BCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || _IX86_UW )

#ifdef _USING_SYSV4_OR_DGUX

#ifdef __STDC__
_EXTERN float	acosf 		_PROTO_ARGS((float));
_EXTERN float	asinf 		_PROTO_ARGS((float));
_EXTERN float	atanf 		_PROTO_ARGS((float));
_EXTERN float	atan2f 		_PROTO_ARGS((float, float));
_EXTERN float	cosf 		_PROTO_ARGS((float));
_EXTERN float	sinf 		_PROTO_ARGS((float));
_EXTERN float	tanf 		_PROTO_ARGS((float));

_EXTERN float	coshf 		_PROTO_ARGS((float));
_EXTERN float	sinhf 		_PROTO_ARGS((float));
_EXTERN float	tanhf 		_PROTO_ARGS((float));

_EXTERN float	expf 		_PROTO_ARGS((float));
_EXTERN float	logf 		_PROTO_ARGS((float));
_EXTERN float	log10f 		_PROTO_ARGS((float));

_EXTERN float	powf 		_PROTO_ARGS((float, float));
_EXTERN float	sqrtf 		_PROTO_ARGS((float));

_EXTERN float	ceilf 		_PROTO_ARGS((float));
_EXTERN float	fabsf 		_PROTO_ARGS((float));
_EXTERN float	floorf 		_PROTO_ARGS((float));
_EXTERN float	fmodf 		_PROTO_ARGS((float, float));
_EXTERN float	modff 		_PROTO_ARGS((float, float *));
#endif /* #ifdef __STDC__ */

_EXTERN double	scalb 		_PROTO_ARGS((double, double));
_EXTERN double	logb 		_PROTO_ARGS((double));
_EXTERN double	nextafter	_PROTO_ARGS((double, double));
_EXTERN double	acosh 		_PROTO_ARGS((double));
_EXTERN double	asinh 		_PROTO_ARGS((double));
_EXTERN double	atanh 		_PROTO_ARGS((double));
_EXTERN double	cbrt 		_PROTO_ARGS((double));
_EXTERN double	copysign	_PROTO_ARGS((double, double));
_EXTERN double	rint 		_PROTO_ARGS((double));
_EXTERN double	remainder	_PROTO_ARGS((double, double));
_EXTERN int	unordered	_PROTO_ARGS((double, double));
_EXTERN int	finite		_PROTO_ARGS((double));

#endif	/* #ifdef _USING_SYSV4_OR_DGUX */

#ifdef _USING_XPG3_OR_SYSV4_OR_DGUX

_EXTERN int	isnan 		_PROTO_ARGS((double));

#endif	/* #ifdef _USING_XPG3_OR_SYSV4_OR_DGUX */

#ifdef _USING_XPG3_OR_SYSV3_OR_BSD_OR_DGUX

_EXTERN double	lgamma 		_PROTO_ARGS((double));

#if _IX86_M88KDATA_DG_ANY_C
  #pragma datarep(ix86)
  #pragma esnameprefix(off)
#endif

_EXTERN _IX86_M88KDATA_SCALAR(int)	signgam;

#if _IX86_M88KDATA_DG_ANY_C
  #pragma esnameprefix(on)
  #pragma datarep(m88k)
#endif

#endif	/* #ifdef _USING_XPG3_OR_SYSV3_OR_BSD_OR_DGUX */

#endif	/* #if (_M88K_BCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
           _IX86_UW ) */

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ABI || \
     _IX86_ANY_DG || _IX86_UW )

#ifdef _USING_XPG3_OR_SYSV3_OR_BSD_OR_DGUX

_EXTERN double	gamma 		_PROTO_ARGS((double));
_EXTERN double	j0     		_PROTO_ARGS((double));
_EXTERN double	j1     		_PROTO_ARGS((double));
_EXTERN double	jn     		_PROTO_ARGS((int, double));
_EXTERN double	y0     		_PROTO_ARGS((double));
_EXTERN double	y1     		_PROTO_ARGS((double));
_EXTERN double	yn     		_PROTO_ARGS((int, double));
_EXTERN double	erf    		_PROTO_ARGS((double));
_EXTERN double	erfc   		_PROTO_ARGS((double));
_EXTERN double	hypot  		_PROTO_ARGS((double, double));

#endif	/* #ifdef _USING_XPG3_OR_SYSV3_OR_BSD_OR_DGUX */

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
     _IX86_UW )

#ifdef _USING_SYSV3_OR_BSD_OR_DGUX

_EXTERN double	atof		_PROTO_ARGS((const char *));

#endif /* #ifdef _USING_SYSV3_OR_BSD_OR_DGUX */

#endif /* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
          _IX86_ANY_DG || _IX86_UW ) */

#endif	/* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
           _IX86_ABI || _IX86_ANY_DG || _IX86_UW ) */

#if (_M88K_BCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || _IX86_UW )

#ifdef _USING_DGUX

_EXTERN double	drem 		_PROTO_ARGS((double, double));

#endif	/* #ifdef _USING_DGUX */

#endif	/* #if (_M88K_BCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
           _IX86_UW ) */

#if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || _IX86_ANY_DG || \
     _IX86_UW )

#ifdef _USING_XPG3_OR_SYSV3_OR_DGUX

#define M_E		2.7182818284590452354
#define M_LOG2E		1.4426950408889634074
#define M_LOG10E        0.43429448190325182765
#define M_LN2		0.69314718055994530942
#define M_LN10		2.30258509299404568402
#define M_PI		3.14159265358979323846
#define M_PI_2		1.57079632679489661923
#define M_PI_4		0.78539816339744830962
#define M_1_PI		0.31830988618379067154
#define M_2_PI		0.63661977236758134308
#define M_2_SQRTPI      1.12837916709551257390
#define M_SQRT2		1.41421356237309504880
#define M_SQRT1_2	0.70710678118654752440

#ifndef __INT_MAXFLOAT_H
#include <_int_MAXFLOAT.h>
#endif

#endif  /* #ifdef _USING_XPG3_OR_SYSV3_OR_DGUX */
 
#ifdef _USING_SYSV3_OR_DGUX

#ifndef __INT_ERRNO_H
#include <_int_errno.h>
#endif

#ifndef __INT_MAXFLOAT_H
#include <_int_MAXFLOAT.h>
#endif

#define HUGE		HUGE_VAL

#define _ABS(x)	((x) < 0 ? -(x) : (x))
#define _REDUCE(TYPE, X, XN, C1, C2)	{ \
	double x1 = (double)(TYPE)X, x2 = X - x1; \
	X = x1 - (XN) * (C1); X += x2; X -= (XN) * (C2); }
#define _POLY1(x, c)	((c)[0] * (x) + (c)[1])
#define _POLY2(x, c)	(_POLY1((x), (c)) * (x) + (c)[2])
#define _POLY3(x, c)	(_POLY2((x), (c)) * (x) + (c)[3])
#define _POLY4(x, c)	(_POLY3((x), (c)) * (x) + (c)[4])
#define _POLY5(x, c)	(_POLY4((x), (c)) * (x) + (c)[5])
#define _POLY6(x, c)	(_POLY5((x), (c)) * (x) + (c)[6])
#define _POLY7(x, c)	(_POLY6((x), (c)) * (x) + (c)[7])
#define _POLY8(x, c)	(_POLY7((x), (c)) * (x) + (c)[8])
#define _POLY9(x, c)	(_POLY8((x), (c)) * (x) + (c)[9])

#if _IX86_M88KDATA_DG_C
  #pragma datarep(ix86)
  #pragma esnameprefix(off)
#endif



#if defined(__cplusplus) || defined(_IX86_M88KDATA_DG_CPLUSPLUS)
struct __math_exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};
#else
#ifdef __cplusplus
#define exception __math_exception
#endif
struct exception {
#ifdef __cplusplus
#undef exception
#endif
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};
#endif


#if !defined(_IX86_M88KDATA_DG_CPLUSPLUS)
/* Not available in BE C++ sde.  If we make a .it file for it,
   it would probably need to be a 'native' one, since matherr is something
   that the user can define for libm to call into when an error occurs.
   But if we do an it file, so that matherr() is mapped to an M88K_matherr()
   in the users program, we'll get link errors when they don't define
   M88K_matherr() */
/* If you need to use this in BE C++ sde, then put matherr in its own
   module and build it with ecc */
#if defined(__cplusplus) 
_EXTERN int matherr             _PROTO_ARGS((struct __math_exception *));
#else
#ifdef __cplusplus
#define exception __math_exception
#endif
_EXTERN int matherr		_PROTO_ARGS((struct exception *));
#ifdef __cplusplus
#undef exception
#endif
#endif
#endif

#if _IX86_M88KDATA_DG_C
  #pragma esnameprefix(on)
  #pragma datarep(m88k)
#endif

#define NOEXC		0	/* no exception to report */
#define DOMAIN		1
#define	SING		2
#define	OVERFLOW	3
#define	UNDERFLOW	4
#define	TLOSS		5
#define	PLOSS		6

#endif /* #ifdef _USING_SYSV3_OR_DGUX */

#endif /* #if (_M88K_BCS || _M88K_OCS || _M88K_DGCOFF || _M88K_DG || \
          _IX86_ANY_DG || _IX86_UW ) */

#endif /* #ifndef _MATH_H */
